/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.command;

import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.command.SpreadsheetCommand;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;

public class SizeChangeCommand
extends SpreadsheetCommand {
    private final Type type;
    private Object[] values;
    private Integer[] indexes;

    public SizeChangeCommand(Spreadsheet spreadsheet, Type type) {
        super(spreadsheet);
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public void captureValues(Integer[] indexes) {
        this.indexes = indexes;
        this.values = new Object[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            this.values[i] = this.getCurrentValue(indexes[i] - 1);
        }
    }

    @Override
    public void execute() {
        for (int i = 0; i < this.indexes.length; ++i) {
            this.values[i] = this.updateValue(this.indexes[i] - 1, this.values[i]);
        }
    }

    @Override
    public CellReference getSelectedCellReference() {
        return null;
    }

    @Override
    public CellRangeAddress getPaintedCellRange() {
        return null;
    }

    private Object updateValue(int index, Object value) {
        if (this.type == Type.COLUMN) {
            Object columnWidth = this.getCurrentValue(index);
            this.spreadsheet.setColumnWidth(index, (Integer)value);
            return columnWidth;
        }
        if (this.type == Type.ROW) {
            Row row = this.spreadsheet.getActiveSheet().getRow(index);
            Object oldHeight = this.getCurrentValue(index);
            if (value == null && row != null) {
                this.spreadsheet.setRowHeight(index, this.spreadsheet.getDefaultRowHeight());
            } else if (value != null) {
                this.spreadsheet.setRowHeight(index, ((Float)value).floatValue());
            }
            return oldHeight;
        }
        return null;
    }

    private Object getCurrentValue(int index) {
        if (this.type == Type.COLUMN) {
            if (this.getSheet().isColumnHidden(index)) {
                return 0;
            }
            return Float.valueOf(this.getSheet().getColumnWidthInPixels(index));
        }
        if (this.type == Type.ROW) {
            Row row = this.getSheet().getRow(index);
            return row == null ? null : Float.valueOf(row.getZeroHeight() ? 0.0f : row.getHeightInPoints());
        }
        return null;
    }

    public static enum Type {
        COLUMN,
        ROW;

    }
}

