/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Label;
import com.vaadin.flow.component.spreadsheet.ChartCreator;
import com.vaadin.flow.component.spreadsheet.MinimizableComponentContainer;
import com.vaadin.flow.component.spreadsheet.SheetOverlayWrapper;
import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.client.OverlayInfo;
import java.io.Serializable;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFChart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SheetChartWrapper
extends SheetOverlayWrapper
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SheetChartWrapper.class);
    private static final String CHART_CREATOR_IMPL = "spreadsheet.chart.creator.implementation";
    private static final String DEFAULT_CHART_CREATOR = "com.vaadin.flow.component.spreadsheet.charts.converter.DefaultChartCreator";
    private static final String INTEGRATION_MISSING_TEXT = "<b>CHART PLACEHOLDER</b><br/>To see charts in your spreadsheet, you need to add the <span class=\"code-snippet\">vaadin-spreadsheet-charts</span> dependency to your project. Alternatively, you can call <span class=\"code-snippet\">Spreadsheet.setChartsEnabled(false)</span> to disable them. Visit <a href=\"https://vaadin.com/spreadsheet\">vaadin.com/spreadsheet</a> for more info.";
    private MinimizableComponentContainer wrapper;
    private String connectorId;
    private static ChartCreator chartCreator;
    private final XSSFChart chartXml;
    private final Spreadsheet spreadsheet;

    public SheetChartWrapper(XSSFChart chartXml, Spreadsheet spreadsheet) {
        super((ClientAnchor)chartXml.getGraphicFrame().getAnchor());
        this.chartXml = chartXml;
        this.spreadsheet = spreadsheet;
        this.wrapper = new MinimizableComponentContainer();
        this.wrapper.setSizeFull();
    }

    private void initContent(XSSFChart chartXml, Spreadsheet spreadsheet) {
        if (this.wrapper.getContent() == null) {
            Component content;
            if (chartCreator != null) {
                content = chartCreator.createChart(chartXml, spreadsheet);
            } else {
                Label label = new Label(INTEGRATION_MISSING_TEXT);
                label.addClassName("overlay-content");
                content = new Div(new Component[]{label});
            }
            this.wrapper.setContent(content);
            ((HasSize)content).setSizeFull();
        }
    }

    @Override
    public void setOverlayChangeListener(SheetOverlayWrapper.OverlayChangeListener listener) {
        this.wrapper.setMinimizeListener(listener);
    }

    public static void setChartCreator(ChartCreator newChartCreator) {
        chartCreator = newChartCreator;
    }

    @Override
    public String getId() {
        if (this.wrapper != null && this.wrapper.isAttached()) {
            this.connectorId = this.wrapper.getId().orElse("");
        }
        return this.connectorId;
    }

    @Override
    public Component getComponent(boolean init) {
        if (init) {
            this.initContent(this.chartXml, this.spreadsheet);
        }
        return this.wrapper;
    }

    @Override
    public OverlayInfo.Type getType() {
        return OverlayInfo.Type.COMPONENT;
    }

    @Override
    public float getHeight(Sheet sheet, float[] rowH) {
        if (this.wrapper.isMinimized()) {
            return 0.0f;
        }
        return super.getHeight(sheet, rowH);
    }

    @Override
    public float getWidth(Sheet sheet, int[] colW, int defaultColumnWidthPX) {
        if (this.wrapper.isMinimized()) {
            return 0.0f;
        }
        return super.getWidth(sheet, colW, defaultColumnWidthPX);
    }

    static {
        String implementation = System.getProperty(CHART_CREATOR_IMPL);
        if (implementation == null) {
            implementation = DEFAULT_CHART_CREATOR;
        }
        if (implementation.length() > 0 && !implementation.equals("true")) {
            try {
                Class<?> clazz = Class.forName(implementation);
                if (ChartCreator.class.isAssignableFrom(clazz)) {
                    SheetChartWrapper.setChartCreator((ChartCreator)clazz.newInstance());
                }
            }
            catch (Exception e) {
                LOGGER.warn("Vaadin Spreadsheet: To display charts you need to add the chart integration package and Vaadin Charts to the project");
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
    }
}

