/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.spreadsheet.ItemFilter;
import com.vaadin.flow.component.spreadsheet.PopupButton;
import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.SpreadsheetFilter;
import com.vaadin.flow.component.spreadsheet.SpreadsheetTable;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class SpreadsheetFilterTable
extends SpreadsheetTable
implements ComponentEventListener {
    public static final String CLEAR_FILTERS_BUTTON_CLASSNAME = "clear-filters-button";
    public static final String FILTER_TABLE_CONTENT_CLASSNAME = "spreadsheet-filter-table-content";
    protected final Map<PopupButton, HashSet<SpreadsheetFilter>> popupButtonToFiltersMap = new HashMap<PopupButton, HashSet<SpreadsheetFilter>>();
    protected final Map<PopupButton, Button> popupButtonToClearButtonMap = new HashMap<PopupButton, Button>();
    protected CellRangeAddress filteringRegion;

    public SpreadsheetFilterTable(Spreadsheet spreadsheet, CellRangeAddress fullTableRegion) {
        this(spreadsheet, spreadsheet.getActiveSheet(), fullTableRegion);
    }

    public SpreadsheetFilterTable(Spreadsheet spreadsheet, Sheet sheet, CellRangeAddress fullTableRegion) {
        super(spreadsheet, sheet, fullTableRegion);
        this.filteringRegion = new CellRangeAddress(fullTableRegion.getFirstRow() + 1, fullTableRegion.getLastRow(), fullTableRegion.getFirstColumn(), fullTableRegion.getLastColumn());
        if (this.isTableSheetCurrentlyActive()) {
            this.initFilters();
            this.initClearAllButtons();
        }
    }

    @Override
    public void reload() {
        super.reload();
        if (this.isTableSheetCurrentlyActive()) {
            if (this.popupButtonToFiltersMap.isEmpty()) {
                this.initFilters();
            }
            if (this.popupButtonToClearButtonMap.isEmpty()) {
                this.initClearAllButtons();
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.popupButtonToClearButtonMap.clear();
        this.popupButtonToFiltersMap.clear();
    }

    public void clearAllFilters() {
        for (Map.Entry<PopupButton, HashSet<SpreadsheetFilter>> entry : this.popupButtonToFiltersMap.entrySet()) {
            PopupButton popupButton = entry.getKey();
            HashSet<SpreadsheetFilter> filters = entry.getValue();
            for (SpreadsheetFilter filter : filters) {
                filter.clearFilter();
            }
            this.popupButtonToClearButtonMap.get((Object)popupButton).setEnabled(false);
            popupButton.markActive(false);
        }
        Spreadsheet spreadsheet = this.getSpreadsheet();
        for (int r = this.filteringRegion.getFirstRow(); r <= this.filteringRegion.getLastRow(); ++r) {
            spreadsheet.setRowHidden(r, false);
        }
    }

    protected void initClearAllButtons() {
        for (PopupButton popupButton : this.getPopupButtons()) {
            Button clearButton = this.createClearButton();
            this.addComponentToPopup(popupButton, (Component)clearButton);
            this.popupButtonToClearButtonMap.put(popupButton, clearButton);
        }
    }

    protected void initFilters() {
        this.initItemFilters();
    }

    protected void initItemFilters() {
        int firstRow = this.filteringRegion.getFirstRow();
        int lastRow = this.filteringRegion.getLastRow();
        for (PopupButton popupButton : this.getPopupButtons()) {
            int column = popupButton.getColumn();
            ItemFilter itemFilter = new ItemFilter(new CellRangeAddress(firstRow, lastRow, column, column), this.getSpreadsheet(), popupButton, this);
            this.addComponentToPopup(popupButton, (Component)itemFilter);
            this.registerFilter(popupButton, itemFilter);
        }
    }

    private void addComponentToPopup(PopupButton popupButton, Component component) {
        if (popupButton.getContent() == null) {
            Div content = new Div();
            content.addClassName(FILTER_TABLE_CONTENT_CLASSNAME);
            popupButton.setContent((Component)content);
        }
        ((Div)popupButton.getContent()).add(new Component[]{component});
    }

    protected Button createClearButton() {
        Button button = new Button("Clear filters", (ComponentEventListener)this);
        button.setDisableOnClick(true);
        button.setEnabled(false);
        button.addClassName(CLEAR_FILTERS_BUTTON_CLASSNAME);
        button.addClickListener((ComponentEventListener & Serializable)event -> this.clearAllFilters());
        return button;
    }

    public CellRangeAddress getFilteringRegion() {
        return this.filteringRegion;
    }

    public void onFiltersUpdated() {
        HashSet filteredRows = new HashSet();
        for (Map.Entry<PopupButton, HashSet<SpreadsheetFilter>> entry : this.popupButtonToFiltersMap.entrySet()) {
            PopupButton popupButton = entry.getKey();
            HashSet<SpreadsheetFilter> filters = entry.getValue();
            HashSet<Integer> temp = new HashSet<Integer>();
            for (SpreadsheetFilter filter : filters) {
                temp.addAll(filter.getFilteredRows());
            }
            this.popupButtonToClearButtonMap.get((Object)popupButton).setEnabled(!temp.isEmpty());
            popupButton.markActive(!temp.isEmpty());
            filteredRows.addAll(temp);
        }
        Spreadsheet spreadsheet = this.getSpreadsheet();
        for (int r = this.filteringRegion.getFirstRow(); r <= this.filteringRegion.getLastRow(); ++r) {
            spreadsheet.setRowHidden(r, filteredRows.contains(r));
        }
    }

    public void registerFilter(PopupButton popupButton, SpreadsheetFilter filter) {
        if (this.getPopupButtons().contains((Object)popupButton)) {
            if (this.popupButtonToFiltersMap.containsKey((Object)popupButton)) {
                this.popupButtonToFiltersMap.get((Object)popupButton).add(filter);
            } else {
                HashSet<SpreadsheetFilter> filters = new HashSet<SpreadsheetFilter>();
                filters.add(filter);
                this.popupButtonToFiltersMap.put(popupButton, filters);
            }
        } else {
            throw new IllegalArgumentException("PopupButton is not inside this filterable Table");
        }
    }

    public void unRegisterFilter(PopupButton popupButton, SpreadsheetFilter filter) {
        HashSet<SpreadsheetFilter> filters = this.popupButtonToFiltersMap.get((Object)popupButton);
        filters.remove(filter);
        if (filters.isEmpty()) {
            this.popupButtonToFiltersMap.remove((Object)popupButton);
        }
    }

    public void onComponentEvent(ComponentEvent event) {
        if (event instanceof ClickEvent) {
            event.getSource().getParent().ifPresent(parent -> {
                if (parent instanceof PopupButton && this.popupButtonToFiltersMap.containsKey(parent)) {
                    HashSet<SpreadsheetFilter> filters = this.popupButtonToFiltersMap.get(parent);
                    for (SpreadsheetFilter filter : filters) {
                        filter.clearFilter();
                    }
                    ((PopupButton)((Object)parent)).markActive(false);
                    this.onFiltersUpdated();
                }
            });
        }
    }
}

