/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import com.vaadin.flow.component.spreadsheet.CustomDataFormatter;
import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.ss.formula.WorkbookEvaluatorProvider;
import org.apache.poi.ss.formula.eval.AreaEval;
import org.apache.poi.ss.formula.eval.RefEval;
import org.apache.poi.ss.formula.eval.RefListEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;

public class SpreadsheetUtil
implements Serializable {
    private static final Pattern keyParser = Pattern.compile("-?\\d+");
    private static final short EXCEL_COLUMN_WIDTH_FACTOR = 256;
    private static final int UNIT_OFFSET_LENGTH = 7;
    private static final int[] UNIT_OFFSET_MAP = new int[]{0, 36, 73, 109, 146, 182, 219};

    public static final String toKey(int col, int row) {
        return "col" + col + " row" + row;
    }

    public static final String toKey(Cell cell) {
        return SpreadsheetUtil.toKey(cell.getColumnIndex() + 1, cell.getRowIndex() + 1);
    }

    public static boolean cellContainsDate(Cell cell) {
        return cell.getCellType() == CellType.NUMERIC && DateUtil.isCellDateFormatted((Cell)cell);
    }

    public static CellReference relativeToAbsolute(Spreadsheet sheet, CellReference cell) {
        String sheetName = sheet.getActiveSheet().getSheetName();
        return new CellReference(sheetName, cell.getRow(), (int)cell.getCol(), true, true);
    }

    public static String getColHeader(int columnIndex) {
        Object h = "";
        while (columnIndex > 0) {
            h = (char)(65 + (columnIndex - 1) % 26) + (String)h;
            columnIndex = (columnIndex - 1) / 26;
        }
        return h;
    }

    public static int getColHeaderIndex(String header) {
        header = header.toUpperCase();
        int x = 0;
        for (int i = 0; i < header.length(); ++i) {
            char h = header.charAt(i);
            x = h - 65 + 1 + x * 26;
        }
        return x;
    }

    public static boolean isCellInRange(CellReference cellReference, CellRangeAddress cellRange) {
        return cellRange.isInRange(cellReference.getRow(), (int)cellReference.getCol());
    }

    public static int getFirstVisibleSheetPOIIndex(Workbook workbook) {
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            if (workbook.isSheetHidden(i) && workbook.isSheetVeryHidden(i)) continue;
            return i;
        }
        return 0;
    }

    public static int getNumberOfVisibleSheets(Workbook workbook) {
        int result = 0;
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            if (workbook.isSheetHidden(i) || workbook.isSheetVeryHidden(i)) continue;
            ++result;
        }
        return result;
    }

    public static int getColumnIndexFromKey(String key) {
        Matcher matcher = keyParser.matcher(key);
        matcher.find();
        return Integer.valueOf(matcher.group());
    }

    public static int getRowFromKey(String key) {
        Matcher matcher = keyParser.matcher(key);
        matcher.find();
        matcher.find();
        return Integer.valueOf(matcher.group());
    }

    static short pixel2WidthUnits(int pxs) {
        short widthUnits = (short)(256 * (pxs / 7));
        widthUnits = (short)(widthUnits + UNIT_OFFSET_MAP[pxs % 7]);
        return widthUnits;
    }

    static int getDefaultColumnWidthInPx() {
        return 70;
    }

    public static Double parsePercentage(String cellContent, Locale locale) {
        String sub;
        Double num;
        if (cellContent == null || cellContent.length() < 2) {
            return null;
        }
        char last = cellContent.charAt(cellContent.length() - 1);
        if (last == '%' && (num = SpreadsheetUtil.parseNumber(sub = cellContent.substring(0, cellContent.length() - 1), locale)) != null) {
            return num / 100.0;
        }
        return null;
    }

    public static Double parseNumber(Cell cell, String value, Locale locale) {
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        if (cell.getCellStyle().getDataFormatString() != null) {
            CustomDataFormatter df = new CustomDataFormatter(locale);
            try {
                Method formatter = df.getClass().getDeclaredMethod("getFormat", Cell.class);
                formatter.setAccessible(true);
                Format format = (Format)formatter.invoke((Object)df, cell);
                if (format != null) {
                    ParsePosition parsePosition = new ParsePosition(0);
                    Object parsed = format.parseObject(value, parsePosition);
                    if (parsePosition.getIndex() == value.length()) {
                        if (parsed instanceof Double) {
                            return (Double)parsed;
                        }
                        if (parsed instanceof Number) {
                            return ((Number)parsed).doubleValue();
                        }
                    }
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return SpreadsheetUtil.parseNumber(value, locale);
    }

    public static Double parseNumber(String cellContent, Locale locale) {
        block11: {
            if (cellContent == null) {
                return null;
            }
            try {
                String trimmedContent = cellContent.trim();
                if (locale != null) {
                    ParsePosition pos;
                    Number parse;
                    int indexOfE;
                    boolean decAndGrouping;
                    boolean noDecButCorrect;
                    DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance(locale);
                    DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
                    int groupSep = symbols.getGroupingSeparator();
                    char decSep = symbols.getDecimalSeparator();
                    int groupingIndex = trimmedContent.lastIndexOf(groupSep);
                    int decIndex = trimmedContent.indexOf(decSep);
                    if (groupSep == 160 && groupingIndex == -1 && (groupingIndex = trimmedContent.lastIndexOf(groupSep = 32)) != -1) {
                        trimmedContent = trimmedContent.replaceAll(" ", "\u00a0");
                    }
                    boolean bl = noDecButCorrect = decIndex == -1 && groupingIndex == trimmedContent.length() - 4;
                    if (groupingIndex != -1) {
                        try {
                            String sub = trimmedContent.substring(trimmedContent.length() - 4);
                            if (sub.toLowerCase().contains("e")) {
                                noDecButCorrect = false;
                            }
                        }
                        catch (IndexOutOfBoundsException e) {
                            noDecButCorrect = false;
                        }
                    }
                    boolean bl2 = decAndGrouping = groupingIndex + 4 == decIndex;
                    if (decAndGrouping && (indexOfE = trimmedContent.toLowerCase().indexOf(101)) != -1 && (indexOfE < decIndex || indexOfE == trimmedContent.length() - 1)) {
                        decAndGrouping = false;
                    }
                    if ((groupingIndex == -1 || noDecButCorrect || decAndGrouping) && (parse = format.parse(trimmedContent, pos = new ParsePosition(0))) != null && pos.getIndex() == trimmedContent.length()) {
                        return parse.doubleValue();
                    }
                    break block11;
                }
                trimmedContent = trimmedContent.replace(",", ".");
                Double d = Double.parseDouble(trimmedContent);
                return d;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean needsLeadingQuote(Cell cell) {
        if (cell.getCellType() != CellType.STRING) {
            return false;
        }
        if (cell.getStringCellValue() == null) {
            return false;
        }
        return SpreadsheetUtil.styleHasQuotePrefix(cell);
    }

    private static boolean styleHasQuotePrefix(Cell cell) {
        if (!(cell instanceof XSSFCell)) {
            return true;
        }
        XSSFCellStyle cellStyle = (XSSFCellStyle)cell.getCellStyle();
        if (cellStyle == null || cellStyle.getCoreXf() == null) {
            return false;
        }
        return cellStyle.getCoreXf().getQuotePrefix();
    }

    public static CellRangeAddress getRangeForReference(String formula, Spreadsheet spreadsheet, boolean includeHiddenCells) {
        int minRow = Integer.MAX_VALUE;
        int minCol = Integer.MAX_VALUE;
        int maxRow = 0;
        int maxCol = 0;
        for (CellReference ref : SpreadsheetUtil.getAllReferencedCells(formula, spreadsheet, includeHiddenCells)) {
            minRow = Math.min(minRow, ref.getRow());
            maxRow = Math.max(maxRow, ref.getRow());
            minCol = Math.min(minCol, ref.getCol());
            maxCol = Math.max(maxCol, ref.getCol());
        }
        return new CellRangeAddress(minRow, maxRow, minCol, maxCol);
    }

    public static List<CellReference> getAllReferencedCells(String formula, Spreadsheet spreadsheet, boolean includeHiddenCells) {
        ArrayList<CellReference> cellRefs = new ArrayList<CellReference>();
        SpreadsheetUtil.getAllReferencedCells(((WorkbookEvaluatorProvider)spreadsheet.getFormulaEvaluator())._getWorkbookEvaluator().evaluate(formula, new CellReference(spreadsheet.getActiveSheet().getSheetName(), 0, 0, false, false)), spreadsheet, cellRefs);
        if (includeHiddenCells) {
            return cellRefs;
        }
        ArrayList<CellReference> visibleCells = new ArrayList<CellReference>();
        for (CellReference cr : cellRefs) {
            if (spreadsheet.isRowHidden(cr.getRow()) || spreadsheet.isColumnHidden(cr.getCol())) continue;
            visibleCells.add(cr);
        }
        return visibleCells;
    }

    private static void getAllReferencedCells(ValueEval rawEval, Spreadsheet spreadsheet, List<CellReference> cells) {
        block6: {
            block7: {
                block5: {
                    if (!(rawEval instanceof AreaEval)) break block5;
                    AreaEval areaEval = (AreaEval)rawEval;
                    for (int s = areaEval.getFirstSheetIndex(); s <= areaEval.getLastSheetIndex(); ++s) {
                        for (int r = areaEval.getFirstRow(); r <= areaEval.getLastRow(); ++r) {
                            for (int c = areaEval.getFirstColumn(); c <= areaEval.getLastColumn(); ++c) {
                                cells.add(new CellReference(spreadsheet.getWorkbook().getSheetName(s), r, c, false, false));
                            }
                        }
                    }
                    break block6;
                }
                if (!(rawEval instanceof RefEval)) break block7;
                RefEval refEval = (RefEval)rawEval;
                for (int s = refEval.getFirstSheetIndex(); s <= refEval.getLastSheetIndex(); ++s) {
                    cells.add(new CellReference(spreadsheet.getWorkbook().getSheetName(s), refEval.getRow(), refEval.getColumn(), false, false));
                }
                break block6;
            }
            if (!(rawEval instanceof RefListEval)) break block6;
            RefListEval list = (RefListEval)rawEval;
            for (ValueEval eval : list.getList()) {
                SpreadsheetUtil.getAllReferencedCells(eval, spreadsheet, cells);
            }
        }
    }
}

