/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.SpreadsheetFactory;
import com.vaadin.flow.component.spreadsheet.command.Command;
import com.vaadin.flow.component.spreadsheet.command.ValueChangeCommand;
import java.io.Serializable;
import java.util.LinkedList;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;

public class SpreadsheetHistoryManager
implements Serializable {
    private int historySize = 20;
    protected int historyIndex = -1;
    protected final LinkedList<Command> commands = new LinkedList();
    protected final Spreadsheet spreadsheet;

    public SpreadsheetHistoryManager(Spreadsheet spreadsheet) {
        this.spreadsheet = spreadsheet;
    }

    public void clear() {
        this.historyIndex = -1;
        this.commands.clear();
    }

    public void addCommand(Command command) {
        SpreadsheetFactory.logMemoryUsage();
        this.discardAllAfter(this.historyIndex);
        this.commands.add(command);
        if (this.commands.size() > this.historySize) {
            this.commands.removeFirst();
        } else {
            ++this.historyIndex;
        }
        SpreadsheetFactory.logMemoryUsage();
    }

    public Command getCommand(int historyIndex) {
        return this.commands.get(historyIndex);
    }

    public boolean canRedo() {
        return this.historyIndex + 1 < this.commands.size();
    }

    public boolean canUndo() {
        return this.historyIndex >= 0;
    }

    public void redo() {
        if (this.canRedo()) {
            Command command = this.commands.get(++this.historyIndex);
            this.makeSureCorrectSheetActive(command);
            command.execute();
            this.changeSelection(command);
            this.fireCellValueChangeEvent(command);
        }
    }

    public void undo() {
        if (this.canUndo()) {
            Command command = this.commands.get(this.historyIndex--);
            this.makeSureCorrectSheetActive(command);
            command.execute();
            this.changeSelection(command);
            this.fireCellValueChangeEvent(command);
        }
    }

    private void fireCellValueChangeEvent(Command command) {
        if (command instanceof ValueChangeCommand) {
            ValueChangeCommand valueUpdaterCommand = (ValueChangeCommand)command;
            this.spreadsheet.fireEvent(new Spreadsheet.CellValueChangeEvent(this.spreadsheet, valueUpdaterCommand.getChangedCells()));
        }
    }

    public void setHistorySize(int historySize) {
        this.historySize = historySize;
        this.discardAllAfter(historySize);
    }

    public int getHistorySize() {
        return this.historySize;
    }

    public int getHistoryIndex() {
        return this.historyIndex;
    }

    protected void makeSureCorrectSheetActive(Command command) {
        if (this.spreadsheet.getActiveSheetIndex() != command.getActiveSheetIndex()) {
            String initialSheetSelection;
            this.spreadsheet.setActiveSheetIndex(command.getActiveSheetIndex());
            CellRangeAddress paintedCellRange = command.getPaintedCellRange();
            CellReference selectedCellReference = command.getSelectedCellReference();
            this.spreadsheet.initialSheetSelection = initialSheetSelection = paintedCellRange != null ? paintedCellRange.formatAsString() : (selectedCellReference != null ? selectedCellReference.formatAsString() : "A1");
        }
    }

    protected void changeSelection(Command command) {
        if (!this.spreadsheet.isRerenderPending()) {
            CellReference selectedCellReference = command.getSelectedCellReference();
            CellRangeAddress paintedCellRange = command.getPaintedCellRange();
            if (selectedCellReference != null) {
                if (paintedCellRange == null) {
                    this.spreadsheet.getCellSelectionManager().onSheetAddressChanged(selectedCellReference.formatAsString(), false);
                } else {
                    this.spreadsheet.getCellSelectionManager().handleCellRangeSelection(selectedCellReference, paintedCellRange, true);
                }
            } else {
                this.spreadsheet.getCellSelectionManager().reSelectSelectedCell();
            }
        }
    }

    protected void discardAllAfter(int index) {
        while (this.commands.size() > index + 1) {
            this.commands.removeLast();
        }
    }
}

