/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Serializer {
    private static final ObjectMapper objectMapper;
    private static final Logger LOGGER;

    Serializer() {
    }

    static String serialize(Object value) {
        try {
            return value == null ? "" : objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Error when serializating to JSON\n value: " + value, (Throwable)e);
            return null;
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(Serializer.class);
        objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
    }
}

