/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.richtextarea;

import java.util.List;

import com.vaadin.shared.AbstractFieldState;
import com.vaadin.shared.annotations.DelegateToWidget;
import com.vaadin.shared.annotations.NoLayout;
import com.vaadin.shared.ui.ValueChangeMode;

/**
 * State for RichTextArea.
 *
 * @since 8.0
 */
public class RichTextAreaState extends AbstractFieldState {
    {
        primaryStyleName = "v-richtextarea";
    }

    /**
     * Maximum character count in text field.
     */
    @DelegateToWidget
    @NoLayout
    public int maxLength = -1;

    /**
     * The text in the field.
     */
    @DelegateToWidget
    @NoLayout
    public String value = "";

    @NoLayout
    public ValueChangeMode valueChangeMode = ValueChangeMode.LAZY;

    @NoLayout
    public int valueChangeTimeout = 400;

    public List<Snippet> snippets = null;
}
