/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.optiongroup;

import com.vaadin.shared.annotations.DelegateToWidget;
import com.vaadin.shared.ui.AbstractSingleSelectState;

/**
 * Shared state for the RadioButtonGroup component.
 *
 * @author Vaadin Ltd.
 * @since 8.0
 */
public class RadioButtonGroupState extends AbstractSingleSelectState {

    {
        primaryStyleName = "v-select-optiongroup";
    }

    /** Is HTML allowed in the item captions. */
    @DelegateToWidget
    public boolean htmlContentAllowed = false;
}
