/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.grid;

import java.util.List;
import java.util.Map;

import com.vaadin.shared.MouseEventDetails;
import com.vaadin.shared.communication.ServerRpc;

/**
 * RPC for firing server side drop event when client side drop event happens on
 * drop target Grid.
 *
 * @author Vaadin Ltd.
 * @since 8.1
 */
public interface GridDropTargetRpc extends ServerRpc {

    /**
     * Called when drop event happens on client side.
     *
     * @param types
     *            List of data types from {@code DataTransfer.types} object.
     * @param data
     *            Map containing all types and corresponding data from the
     *            {@code
     *         DataTransfer} object.
     * @param dropEffect
     *            the desired drop effect
     * @param rowKey
     *            Key of the row on which the drop event occurred.
     * @param dropLocation
     *            Location of the drop within the row.
     * @param mouseEventDetails
     *            Mouse event details object containing information about the
     *            drop event
     */
    public void drop(List<String> types, Map<String, String> data,
            String dropEffect, String rowKey, DropLocation dropLocation,
            MouseEventDetails mouseEventDetails);
}
