/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.dnd.criteria;

/**
 * Comparison operator for drag and drop acceptance criterion.
 *
 * @author Vaadin Ltd.
 * @since 8.1
 */
public enum ComparisonOperator {

    /**
     * Smaller than operator ("&lt;").
     */
    SMALLER_THAN,

    /**
     * Smaller than or equals to operator ("&lt;=").
     */
    SMALLER_THAN_OR_EQUALS,

    /**
     * Equals to operator ("==").
     */
    EQUALS,

    /**
     * Greater than or equals to operator ("&gt;=").
     */
    GREATER_THAN_OR_EQUALS,

    /**
     * Greater than operator ("&gt;").
     */
    GREATER_THAN,

    /**
     * Not equals operator ("!=").
     */
    NOT_EQUALS
}
