/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.dnd;

import com.vaadin.shared.communication.ServerRpc;

/**
 * RPC for firing server side event when client side dragstart event happens on
 * drag source.
 *
 * @author Vaadin Ltd
 * @since 8.1
 */
public interface DragSourceRpc extends ServerRpc {

    /**
     * Called when dragstart event happens on client side.
     */
    public void dragStart();

    /**
     * Called when dragend event happens on client side.
     *
     * @param dropEffect
     *            Drop effect of the dragend event, extracted from {@code
     *         DataTransfer.dropEffect} parameter.
     */
    public void dragEnd(DropEffect dropEffect);
}
