/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.grid;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.vaadin.shared.Connector;
import com.vaadin.shared.ui.ContentMode;

/**
 * Shared state for Grid headers and footers.
 *
 * @author Vaadin Ltd
 * @since 8.0
 */
public class SectionState implements Serializable {

    /** The state of a header or footer row. */
    public static class RowState implements Serializable {

        /** The map from column ids to the cells in this row. */
        public Map<String, CellState> cells = new HashMap<>();

        /** The map from a joint cell to column id sets in this row. */
        public Map<CellState, Set<String>> cellGroups = new HashMap<>();

        /**
         * Whether this row is the default header row. Always false for footer
         * rows.
         */
        public boolean defaultHeader = false;

        /**
         * The style name for the row. Null if none.
         */
        public String styleName = null;
    }

    /** The state of a header or footer cell. */
    public static class CellState implements Serializable {

        public GridStaticCellType type = GridStaticCellType.TEXT;

        /** The style name for this cell. Null if none. */
        public String styleName = null;

        /** The textual caption of this cell. */
        public String text;

        /** The html content of this cell. */
        public String html;

        /**
         * The connector for the component that is set to be displayed in this
         * cell. Null if none.
         */
        public Connector connector = null;

        /** The id of the column that this cell belongs to. */
        public String columnId;

        /** The tooltip for the cell */
        public String description;

        /** The content mode for the tooltip for the cell */
        public ContentMode descriptionContentMode = ContentMode.TEXT;
    }

    /** The rows in this section. */
    public List<RowState> rows = new ArrayList<>();

    /**
     * Visibility of this section.
     *
     * @since 8.1.1
     */
    public boolean visible = true;
}
