/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.treegrid;

import com.vaadin.shared.communication.ClientRpc;

/**
 * RPC to handle focusing in TreeGrid.
 *
 * @author Vaadin Ltd
 * @since 8.1
 */
@FunctionalInterface
public interface FocusRpc extends ClientRpc {

    /**
     * Focuses a cell.
     *
     * @param rowIndex
     *            the row index
     * @param columnIndex
     *            the cell index
     */
    void focusCell(int rowIndex, int columnIndex);
}
