/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.treegrid;

import com.vaadin.shared.communication.ServerRpc;

/**
 * RPC to handle client originated parent focusing in TreeGrid.
 *
 * @author Vaadin Ltd
 * @since 8.1
 */
public interface FocusParentRpc extends ServerRpc {

    /**
     * Focuses cell in the row parent.
     *
     * @param rowKey
     *            the row key
     * @param cellIndex
     *            the cell index
     */
    void focusParent(String rowKey, int cellIndex);
}
