/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui;

import java.util.Map;

import com.vaadin.shared.Connector;
import com.vaadin.shared.communication.ServerRpc;

/**
 * Window order RPC interface.
 * <p>
 * Notifies server when windows order is changed.
 *
 * @author Vaadin Ltd
 * @since 8.0
 *
 */
public interface WindowOrderRpc extends ServerRpc {

    /**
     * Sends RPC request about windows order change.
     *
     * @param windowOrders
     *            new windows order
     */
    void windowOrderChanged(Map<Integer, Connector> windowOrders);
}
