/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui;

/**
 * Constants for border styles used on HTML elements.
 *
 * @author Vaadin Ltd
 * @since 7.0
 *
 */
public enum BorderStyle {
    /**
     * A border style used for using no border.
     */
    NONE,

    /**
     * A border style used for a minimal border.
     */
    MINIMAL,

    /**
     * A border style that indicates that the default border style should be
     * used.
     */
    DEFAULT;
}
