/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.dnd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.vaadin.shared.communication.SharedState;
import com.vaadin.shared.ui.dnd.criteria.Payload;

/**
 * State class containing parameters for DragSourceExtension.
 *
 * @author Vaadin Ltd
 * @since 8.1
 */
public class DragSourceState extends SharedState {

    /**
     * Event identifier for dragend event.
     */
    public static final String EVENT_DRAGEND = "dragend";

    /**
     * Event identifier for dragstart event.
     */
    public static final String EVENT_DRAGSTART = "dragstart";

    /**
     * Data type {@code "text"} for storing data in {@code DataTransfer} object.
     */
    public static final String DATA_TYPE_TEXT = "text";

    /**
     * Data type {@code "Text"}. IE 11 stores data dragged from the desktop as
     * "Text" with capital letter.
     */
    public static final String DATA_TYPE_TEXT_IE = "Text";

    /**
     * Data type {@code "text/plain"} for reading data from {@code DataTransfer}
     * object. Some browsers convert store data with {@code "text"} as {@code
     * "text/plain"} when transferring data.
     */
    public static final String DATA_TYPE_TEXT_PLAIN = "text/plain";

    public static final String RESOURCE_DRAG_IMAGE = "drag-image";

    /**
     * {@code DataTransfer.effectAllowed} parameter for the drag event.
     */
    public EffectAllowed effectAllowed = EffectAllowed.UNINITIALIZED;

    /**
     * {@code DataTransfer.types} parameter. Used to keep track of data formats
     * set for the drag event.
     */
    public List<String> types = new ArrayList<>();

    /**
     * Used to store data in the {@code DataTransfer} object for the drag event.
     */
    public Map<String, String> data = new HashMap<>();

    /**
     * Payload for comparing against acceptance criteria. Transferred in the
     * {@code DataTransfer} object as data type.
     */
    public Map<String, Payload> payload = new HashMap<>();
}
