/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.dnd.criteria;

/**
 * Comparison operator for drag and drop acceptance criterion.
 *
 * @author Vaadin Ltd.
 * @since 8.1
 */
public enum ComparisonOperator {

    /**
     * Smaller than operator ("<").
     */
    SMALLER_THAN,

    /**
     * Smaller than or equals to operator ("<=").
     */
    SMALLER_THAN_OR_EQUALS,

    /**
     * Equals to operator ("==").
     */
    EQUALS,

    /**
     * Greater than or equals to operator (">=").
     */
    GREATER_THAN_OR_EQUALS,

    /**
     * Greater than operator (">").
     */
    GREATER_THAN,

    /**
     * Not equals operator ("!=").
     */
    NOT_EQUALS
}
