/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.ui;

import com.vaadin.server.SerializablePredicate;

/**
 * A callback interface for resolving whether client-side collapsing should be
 * allowed for an item in a listing component that displays hierarchical data,
 * such as {@link TreeGrid}.
 *
 * @author Vaadin Ltd
 * @since 8.1
 *
 * @see TreeGrid#setItemCollapseAllowedProvider(ItemCollapseAllowedProvider)
 *
 * @param <T>
 *            item data type
 */
@FunctionalInterface
public interface ItemCollapseAllowedProvider<T>
        extends SerializablePredicate<T> {

    /**
     * Returns whether collapsing is allowed for the given item.
     *
     * @param item
     *            the item to test
     * @return {@code true} if collapse is allowed for the given item,
     *         {@code false} otherwise
     */
    @Override
    boolean test(T item);
}
