/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.ui.components.grid;

import com.vaadin.shared.ui.treegrid.TreeGridDragSourceState;
import com.vaadin.ui.TreeGrid;

/**
 * Makes a TreeGrid's rows draggable for HTML5 drag and drop functionality.
 * <p>
 * When dragging a selected row, all the visible selected rows are dragged. Note
 * that ONLY visible rows are taken into account and the subtree belonging to a
 * selected row is not dragged either.
 *
 * @param <T>
 *            The TreeGrid bean type.
 * @author Vaadin Ltd.
 * @since 8.1
 */
public class TreeGridDragSource<T> extends GridDragSource<T> {

    /**
     * Extends a TreeGrid and makes it's rows draggable.
     *
     * @param target
     *            TreeGrid to be extended.
     */
    public TreeGridDragSource(TreeGrid<T> target) {
        super(target);
    }

    @Override
    protected TreeGridDragSourceState getState() {
        return (TreeGridDragSourceState) super.getState();
    }

    @Override
    protected TreeGridDragSourceState getState(boolean markAsDirty) {
        return (TreeGridDragSourceState) super.getState(markAsDirty);
    }
}
