/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.ui.components.grid;

import java.io.Serializable;

/**
 * A handler for calculating the index of the dropped items on the drop target
 * grid.
 *
 * @author Vaadin Ltd
 * @since 8.2
 * @see GridRowDragger
 * @param <T>
 *            the bean type
 */
@FunctionalInterface
public interface DropIndexCalculator<T> extends Serializable {

    /**
     * Returns a calculator for always dropping items to the end of the target
     * grid, regardless of drop position.
     *
     * @return the created drop index calculator
     */
    static <T> DropIndexCalculator<T> alwaysDropToEnd() {
        return (GridDropEvent<T> event) -> Integer.MAX_VALUE;
    }

    /**
     * Called when Items are dropped onto a target grid.
     *
     * @param event
     *            the GridDropEvent.
     * @return index the target index, use {@link Integer#MAX_VALUE} for always
     *         dropping to end
     */
    public int calculateDropIndex(GridDropEvent<T> event);
}
