/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.server;

import java.util.EventObject;

/**
 * Event object containing information related to connector id generation.
 *
 * @author Vaadin Ltd
 * @since 8.1
 */
public class ConnectorIdGenerationEvent extends EventObject {

    private final VaadinSession session;
    private final ClientConnector connector;

    /**
     * Creates a new event for the given session and connector.
     *
     * @param session
     *            the session for which a connector id is needed, not
     *            <code>null</code>
     * @param connector
     *            the connector that should get an id, not <code>null</code>
     */
    public ConnectorIdGenerationEvent(VaadinSession session,
            ClientConnector connector) {
        super(session.getService());

        assert session != null;
        assert connector != null;

        this.session = session;
        this.connector = connector;
    }

    /**
     * Gets the session for which connector id is needed.
     *
     * @return the session, not <code>null</code>
     */
    public VaadinSession getSession() {
        return session;
    }

    /**
     * Gets the connector that should get an id.
     *
     * @return the connector, not <code>null</code>
     */
    public ClientConnector getConnector() {
        return connector;
    }

    @Override
    public VaadinService getSource() {
        return (VaadinService) super.getSource();
    }
}
