/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.data;

import java.util.Collection;

import com.vaadin.data.provider.DataProvider;

/**
 * A generic interface for listing components that use a data provider for
 * showing data.
 * <p>
 * A listing component should implement either this interface or
 * {@link HasFilterableDataProvider}, but not both.
 *
 * @author Vaadin Ltd.
 *
 * @param <T>
 *            the item data type
 * @since 8.0
 *
 * @see HasFilterableDataProvider
 */
public interface HasDataProvider<T> extends HasItems<T> {

    /**
     * Sets the data provider for this listing. The data provider is queried for
     * displayed items as needed.
     *
     * @param dataProvider
     *            the data provider, not null
     */
    public void setDataProvider(DataProvider<T, ?> dataProvider);

    @Override
    public default void setItems(Collection<T> items) {
        setDataProvider(DataProvider.ofCollection(items));
    }

}
