/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.renderer;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.Rendering;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementAttachListener;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.internal.JsonSerializer;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.internal.nodefeature.ReturnChannelMap;
import com.vaadin.flow.internal.nodefeature.ReturnChannelRegistration;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonArray;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;

@JsModule(value="./lit-renderer.ts")
public class LitRenderer<SOURCE>
extends Renderer<SOURCE> {
    private final String templateExpression;
    private final String propertyNamespace;
    private final Map<String, ValueProvider<SOURCE, ?>> valueProviders = new HashMap();
    private final Map<String, SerializableBiConsumer<SOURCE, JsonArray>> clientCallables = new HashMap<String, SerializableBiConsumer<SOURCE, JsonArray>>();
    private final String ALPHANUMERIC_REGEX = "^[a-zA-Z0-9]+$";

    private LitRenderer(String templateExpression) {
        this.templateExpression = templateExpression;
        int litRendererCount = 0;
        if (UI.getCurrent() != null) {
            litRendererCount = UI.getCurrent().getElement().getProperty("__litRendererCount", 0);
            UI.getCurrent().getElement().setProperty("__litRendererCount", (double)(litRendererCount + 1));
        }
        this.propertyNamespace = "lr_" + litRendererCount + "_";
    }

    LitRenderer() {
        this("");
    }

    public static <SOURCE> LitRenderer<SOURCE> of(String templateExpression) {
        Objects.requireNonNull(templateExpression);
        return new LitRenderer<SOURCE>(templateExpression);
    }

    @Override
    public Rendering<SOURCE> render(Element container, DataKeyMapper<SOURCE> keyMapper, String rendererName) {
        final DataGenerator<SOURCE> dataGenerator = this.createDataGenerator();
        final Registration registration = this.createJsRendererFunction(container, keyMapper, rendererName);
        return new Rendering<SOURCE>(){

            @Override
            public Optional<DataGenerator<SOURCE>> getDataGenerator() {
                return Optional.of(dataGenerator);
            }

            @Override
            public Registration getRegistration() {
                return registration;
            }
        };
    }

    private void setElementRenderer(Element container, String rendererName, String templateExpression, ReturnChannelRegistration returnChannel, JsonArray clientCallablesArray, String propertyNamespace) {
        container.executeJs("window.Vaadin.setLitRenderer(this, $0, $1, $2, $3, $4)", new Serializable[]{rendererName, templateExpression, returnChannel, clientCallablesArray, propertyNamespace});
    }

    protected String getTemplateExpression() {
        return this.templateExpression;
    }

    String getPropertyNamespace() {
        return this.propertyNamespace;
    }

    private Registration createJsRendererFunction(Element container, DataKeyMapper<SOURCE> keyMapper, String rendererName) {
        ReturnChannelRegistration returnChannel = ((ReturnChannelMap)container.getNode().getFeature(ReturnChannelMap.class)).registerChannel((SerializableConsumer & Serializable)arguments -> {
            String handlerName = arguments.getString(0);
            String itemKey = arguments.getString(1);
            JsonArray args = arguments.getArray(2);
            SerializableBiConsumer<SOURCE, JsonArray> handler = this.clientCallables.get(handlerName);
            Object item = keyMapper.get(itemKey);
            handler.accept(item, (Object)args);
        });
        JsonArray clientCallablesArray = JsonUtils.listToJson(new ArrayList<String>(this.clientCallables.keySet()));
        ArrayList<Registration> registrations = new ArrayList<Registration>();
        registrations.add(container.addAttachListener((ElementAttachListener & Serializable)e -> this.setElementRenderer(container, rendererName, this.getTemplateExpression(), returnChannel, clientCallablesArray, this.propertyNamespace)));
        if (container.getNode().isAttached()) {
            this.setElementRenderer(container, rendererName, this.getTemplateExpression(), returnChannel, clientCallablesArray, this.propertyNamespace);
        }
        registrations.add((Registration & Serializable)() -> container.executeJs("window.Vaadin.unsetLitRenderer(this, $0, $1)", new Serializable[]{rendererName, this.propertyNamespace}));
        return (Registration & Serializable)() -> registrations.forEach(Registration::remove);
    }

    private DataGenerator<SOURCE> createDataGenerator() {
        return (DataGenerator & Serializable)(item, jsonObject) -> this.valueProviders.forEach((key, provider) -> jsonObject.put(this.propertyNamespace + key, JsonSerializer.toJson((Object)provider.apply(item))));
    }

    public LitRenderer<SOURCE> withProperty(String property, ValueProvider<SOURCE, ?> provider) {
        Objects.requireNonNull(property);
        Objects.requireNonNull(provider);
        this.valueProviders.put(property, provider);
        return this;
    }

    public LitRenderer<SOURCE> withFunction(String functionName, SerializableConsumer<SOURCE> handler) {
        return this.withFunction(functionName, (SerializableBiConsumer & Serializable)(item, ignore) -> handler.accept(item));
    }

    public LitRenderer<SOURCE> withFunction(String functionName, SerializableBiConsumer<SOURCE, JsonArray> handler) {
        Objects.requireNonNull(functionName);
        Objects.requireNonNull(handler);
        if (!Pattern.matches("^[a-zA-Z0-9]+$", functionName)) {
            throw new IllegalArgumentException("Function name must be alphanumeric");
        }
        this.clientCallables.put(functionName, handler);
        return this;
    }

    public Map<String, ValueProvider<SOURCE, ?>> getValueProviders() {
        return Collections.unmodifiableMap(this.valueProviders);
    }

    static {
        UsageStatistics.markAsUsed((String)"flow-components/LitRenderer", null);
    }
}

