/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.progressbar;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.progressbar.ProgressBarVariant;
import com.vaadin.flow.component.shared.HasThemeVariant;

@Tag(value="vaadin-progress-bar")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.1.0"), @NpmPackage(value="@vaadin/progress-bar", version="24.1.0")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/progress-bar/src/vaadin-progress-bar.js")})
public class ProgressBar
extends Component
implements HasSize,
HasStyle,
HasThemeVariant<ProgressBarVariant> {
    public ProgressBar() {
        this(0.0, 1.0);
    }

    public ProgressBar(double min, double max) {
        this(min, max, min);
    }

    public ProgressBar(double min, double max, double value) {
        if (min >= max) {
            throw new IllegalArgumentException(String.format("min ('%s') must be less than max ('%s')", min, max));
        }
        this.setMin(min);
        this.setMax(max);
        this.setValue(value);
    }

    public void setValue(double value) {
        double min = this.getMin();
        double max = this.getMax();
        if (min > value || value > max) {
            throw new IllegalArgumentException(String.format("value must be between min ('%s') and max ('%s')", min, max));
        }
        this.getElement().setProperty("value", value);
    }

    public double getValue() {
        return this.getElement().getProperty("value", 0.0);
    }

    public void setMax(double max) {
        this.getElement().setProperty("max", max);
    }

    public double getMax() {
        return this.getElement().getProperty("max", 0.0);
    }

    public void setMin(double min) {
        this.getElement().setProperty("min", min);
    }

    public double getMin() {
        return this.getElement().getProperty("min", 0.0);
    }

    public void setIndeterminate(boolean indeterminate) {
        this.getElement().setProperty("indeterminate", indeterminate);
    }

    public boolean isIndeterminate() {
        return this.getElement().getProperty("indeterminate", false);
    }
}

