/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.progressbar;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.progressbar.ProgressBarVariant;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Tag(value="vaadin-progress-bar")
@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="23.0.10")
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/progress-bar/src/vaadin-progress-bar.js")})
public abstract class GeneratedVaadinProgressBar<R extends GeneratedVaadinProgressBar<R>>
extends Component
implements HasStyle,
HasTheme {
    public void addThemeVariants(ProgressBarVariant ... variants) {
        this.getThemeNames().addAll((Collection)Stream.of(variants).map(ProgressBarVariant::getVariantName).collect(Collectors.toList()));
    }

    public void removeThemeVariants(ProgressBarVariant ... variants) {
        this.getThemeNames().removeAll((Collection)Stream.of(variants).map(ProgressBarVariant::getVariantName).collect(Collectors.toList()));
    }

    protected double getValueDouble() {
        return this.getElement().getProperty("value", 0.0);
    }

    protected void setValue(double value) {
        this.getElement().setProperty("value", value);
    }

    protected double getMinDouble() {
        return this.getElement().getProperty("min", 0.0);
    }

    protected void setMin(double min) {
        this.getElement().setProperty("min", min);
    }

    protected double getMaxDouble() {
        return this.getElement().getProperty("max", 0.0);
    }

    protected void setMax(double max) {
        this.getElement().setProperty("max", max);
    }

    protected boolean isIndeterminateBoolean() {
        return this.getElement().getProperty("indeterminate", false);
    }

    protected void setIndeterminate(boolean indeterminate) {
        this.getElement().setProperty("indeterminate", indeterminate);
    }
}

