/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.notification.testbench;

import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elementsbase.Element;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;

@Element(value="vaadin-notification")
public class NotificationElement
extends TestBenchElement {
    public boolean isOpen() {
        try {
            return this.getPropertyBoolean(new String[]{"opened"});
        }
        catch (StaleElementReferenceException e) {
            return false;
        }
    }

    public String getText() {
        return this.getCard().getText();
    }

    public SearchContext getContext() {
        return this.getCard();
    }

    private TestBenchElement getCard() {
        TestBenchElement card = this.getPropertyElement(new String[]{"_card"});
        try {
            this.waitUntil(driver -> {
                boolean hasVisibleText = !card.getText().isEmpty();
                boolean hasVisibleChildren = card.findElements(By.cssSelector((String)"*")).stream().anyMatch(element -> element.isDisplayed());
                return hasVisibleText || hasVisibleChildren;
            }, 1L);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        return card;
    }
}

