/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.notification;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.component.notification.GeneratedVaadinNotification;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.HtmlUtils;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;

@HtmlImport(value="frontend://flow-component-renderer.html")
public class Notification
extends GeneratedVaadinNotification<Notification>
implements HasComponents {
    private static final int DEFAULT_DURATION = 5000;
    private static final Position DEFAULT_POSITION = Position.BOTTOM_START;
    private static final SerializableConsumer<UI> NO_OP = (SerializableConsumer & Serializable)ui -> {};
    private final Element container = ElementFactory.createDiv();
    private final Element templateElement = new Element("template");
    private boolean autoAddedToTheUi = false;
    private SerializableConsumer<UI> deferredJob = new AttachComponentTemplate();

    public Notification() {
        this.initBaseElementsAndListeners();
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> this.deferredJob.accept(ui)));
        this.setPosition(DEFAULT_POSITION);
        this.setDuration(0);
    }

    public Notification(String text) {
        this(text, 0, DEFAULT_POSITION);
    }

    public Notification(String text, int duration) {
        this(text, duration, DEFAULT_POSITION);
    }

    public Notification(String text, int duration, Position position) {
        this.initBaseElementsAndListeners();
        this.setText(text);
        this.setDuration((double)duration);
        this.setPosition(position);
    }

    public Notification(Component ... components) {
        this();
        this.add(components);
    }

    private void initBaseElementsAndListeners() {
        this.getElement().appendChild(new Element[]{this.templateElement});
        this.getElement().appendVirtualChild(new Element[]{this.container});
        this.getElement().addEventListener("opened-changed", (DomEventListener & Serializable)event -> {
            if (this.autoAddedToTheUi && !this.isOpened()) {
                this.getElement().removeFromParent();
                this.autoAddedToTheUi = false;
            }
        });
    }

    public static Notification show(String text, int duration, Position position) {
        Notification notification = new Notification(text, duration, position);
        notification.open();
        return notification;
    }

    public static Notification show(String text) {
        return Notification.show(text, 5000, DEFAULT_POSITION);
    }

    public void setText(String text) {
        this.removeAll();
        this.deferredJob = NO_OP;
        this.templateElement.setProperty("innerHTML", HtmlUtils.escape((String)text));
    }

    public void setPosition(Position position) {
        this.setPosition(position.getClientName());
    }

    public Position getPosition() {
        String position = this.getPositionString();
        return Optional.ofNullable(position).map(Position::fromClientName).orElse(DEFAULT_POSITION);
    }

    @Override
    public void open() {
        this.setOpened(true);
    }

    @Override
    public void close() {
        this.setOpened(false);
    }

    public void add(Component ... components) {
        assert (components != null);
        for (Component component : components) {
            assert (component != null);
            this.container.appendChild(new Element[]{component.getElement()});
        }
        this.attachComponentTemplate();
    }

    public void remove(Component ... components) {
        for (Component component : components) {
            assert (component != null);
            if (!this.container.equals((Object)component.getElement().getParent())) {
                throw new IllegalArgumentException("The given component (" + component + ") is not a child of this component");
            }
            this.container.removeChild(new Element[]{component.getElement()});
        }
    }

    public void removeAll() {
        this.container.removeAllChildren();
    }

    public Stream<Component> getChildren() {
        Stream.Builder childComponents = Stream.builder();
        this.container.getChildren().forEach(childElement -> ComponentUtil.findComponents((Element)childElement, childComponents::add));
        return childComponents.build();
    }

    @Override
    public void setOpened(boolean opened) {
        UI ui = UI.getCurrent();
        if (ui == null) {
            throw new IllegalStateException("UI instance is not available. It means that you are calling this method out of a normal workflow where it's always implicitely set. That may happen if you call the method from the custom thread without 'UI::access' or from tests without proper initialization.");
        }
        if (opened && this.getElement().getNode().getParent() == null) {
            ui.beforeClientResponse((Component)ui, (SerializableConsumer & Serializable)context -> {
                ui.add(new Component[]{this});
                this.autoAddedToTheUi = true;
            });
        }
        super.setOpened(opened);
    }

    public boolean isOpened() {
        return this.isOpenedBoolean();
    }

    @Override
    public Registration addOpenedChangeListener(ComponentEventListener<GeneratedVaadinNotification.OpenedChangeEvent<Notification>> listener) {
        return super.addOpenedChangeListener(listener);
    }

    public void setDuration(int duration) {
        this.setDuration((double)duration);
    }

    public int getDuration() {
        return (int)this.getDurationDouble();
    }

    public Registration addAttachListener(ComponentEventListener<AttachEvent> listener) {
        return super.addAttachListener(listener);
    }

    public Registration addDetachListener(ComponentEventListener<DetachEvent> listener) {
        return super.addDetachListener(listener);
    }

    private void attachComponentTemplate() {
        this.deferredJob = new AttachComponentTemplate();
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> this.deferredJob.accept(ui)));
    }

    public static enum Position {
        TOP_STRETCH,
        TOP_START,
        TOP_CENTER,
        TOP_END,
        MIDDLE,
        BOTTOM_START,
        BOTTOM_CENTER,
        BOTTOM_END,
        BOTTOM_STRETCH;

        private final String clientName = this.name().toLowerCase(Locale.ENGLISH).replace('_', '-');

        public String getClientName() {
            return this.clientName;
        }

        static Position fromClientName(String clientName) {
            return clientName == null ? null : Position.valueOf(clientName.replace('-', '_').toUpperCase(Locale.ENGLISH));
        }
    }

    private class AttachComponentTemplate
    implements SerializableConsumer<UI> {
        private AttachComponentTemplate() {
        }

        public void accept(UI ui) {
            if (this == Notification.this.deferredJob) {
                String appId = ui.getInternals().getAppId();
                int nodeId = Notification.this.container.getNode().getId();
                String template = String.format("<flow-component-renderer appid=\"%s\" nodeid=\"%s\"></flow-component-renderer>", appId, nodeId);
                Notification.this.templateElement.setProperty("innerHTML", template);
            }
        }
    }
}

