/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.map;

import com.vaadin.flow.server.StreamResource;
import com.vaadin.flow.server.streams.AbstractDownloadHandler;
import com.vaadin.flow.server.streams.DownloadHandler;
import java.io.Serializable;

public class Assets {
    public static final ImageAsset PIN = new ImageAsset("pin.png", "/META-INF/resources/frontend/vaadin-map/assets/pin.png", 80, 104);
    public static final ImageAsset POINT = new ImageAsset("point.png", "/META-INF/resources/frontend/vaadin-map/assets/point.png", 128, 128);

    public static class ImageAsset
    extends Asset {
        private final int width;
        private final int height;

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        private ImageAsset(String fileName, String resourcePath, int width, int height) {
            super(fileName, resourcePath);
            this.width = width;
            this.height = height;
        }
    }

    public static class Asset
    implements Serializable {
        private final String fileName;
        private final StreamResource resource;
        private final DownloadHandler handler;

        private Asset(String fileName, String resourcePath) {
            this.fileName = fileName;
            this.resource = null;
            this.handler = DownloadHandler.forClassResource(this.getClass(), (String)resourcePath, (String)fileName).inline();
        }

        @Deprecated(since="24.8", forRemoval=true)
        private Asset(String fileName, StreamResource resource) {
            this.fileName = fileName;
            this.resource = resource;
            this.handler = null;
        }

        private Asset(String fileName, DownloadHandler handler) {
            this.fileName = fileName;
            this.resource = null;
            if (handler instanceof AbstractDownloadHandler) {
                AbstractDownloadHandler preDefinedHandler = (AbstractDownloadHandler)handler;
                preDefinedHandler.inline();
            }
            this.handler = handler;
        }

        public String getFileName() {
            return this.fileName;
        }

        @Deprecated(since="24.8", forRemoval=true)
        public StreamResource getResource() {
            return this.resource;
        }

        public DownloadHandler getHandler() {
            return this.handler;
        }
    }
}

