/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.map.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.map.MapBase;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.StreamRegistration;
import com.vaadin.flow.server.StreamResource;
import com.vaadin.flow.server.StreamResourceRegistry;
import com.vaadin.flow.server.streams.DownloadHandler;
import com.vaadin.flow.server.streams.ElementRequestHandler;
import elemental.json.JsonValue;
import elemental.json.impl.JreJsonFactory;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class MapSerializer
implements Serializable {
    private final ObjectWriter writer;
    private final Map<Object, StreamRegistration> streamRegistrationCache = new HashMap<Object, StreamRegistration>();

    public MapSerializer(MapBase map) {
        SimpleModule streamResourceModule = new SimpleModule().addSerializer(StreamResource.class, (JsonSerializer)new StreamResourceSerializer());
        SimpleModule downloadHandlerModule = new SimpleModule().addSerializer(DownloadHandler.class, (JsonSerializer)new DownloadHandlerSerializer());
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)streamResourceModule);
        mapper.registerModule((Module)downloadHandlerModule);
        this.writer = mapper.writer();
        map.addDetachListener((ComponentEventListener & Serializable)event -> {
            this.streamRegistrationCache.values().forEach(StreamRegistration::unregister);
            this.streamRegistrationCache.clear();
        });
    }

    public JsonValue toJson(Object value) {
        String json;
        try {
            json = this.writer.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error while serializing " + value.getClass().getSimpleName(), e);
        }
        return new JreJsonFactory().parse(json);
    }

    @Deprecated(since="24.8", forRemoval=true)
    private class StreamResourceSerializer
    extends StdSerializer<StreamResource> {
        public StreamResourceSerializer() {
            super(StreamResource.class);
        }

        public void serialize(StreamResource value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            if (value == null) {
                gen.writeNull();
                return;
            }
            URI uri = this.getURI(value);
            gen.writeString(uri.toString());
        }

        private URI getURI(StreamResource resource) {
            StreamRegistration registration = MapSerializer.this.streamRegistrationCache.get(resource);
            if (registration == null) {
                StreamResourceRegistry resourceRegistry = UI.getCurrent().getSession().getResourceRegistry();
                registration = resourceRegistry.registerResource((AbstractStreamResource)resource);
                MapSerializer.this.streamRegistrationCache.put(resource, registration);
            }
            return registration.getResourceUri();
        }
    }

    private class DownloadHandlerSerializer
    extends StdSerializer<DownloadHandler> {
        public DownloadHandlerSerializer() {
            super(DownloadHandler.class);
        }

        public void serialize(DownloadHandler value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            if (value == null) {
                gen.writeNull();
                return;
            }
            URI uri = this.getURI(value);
            gen.writeString(uri.toString());
        }

        private URI getURI(DownloadHandler resource) {
            StreamRegistration registration = MapSerializer.this.streamRegistrationCache.get(resource);
            if (registration == null) {
                StreamResourceRegistry resourceRegistry = UI.getCurrent().getSession().getResourceRegistry();
                registration = resourceRegistry.registerResource((ElementRequestHandler)resource);
                MapSerializer.this.streamRegistrationCache.put(resource, registration);
            }
            return registration.getResourceUri();
        }
    }
}

