/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.map.configuration;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;

public abstract class AbstractConfigurationObject
implements Serializable {
    private String id;
    private boolean dirty = true;
    private static final ThreadLocal<Boolean> trackObjectChanges = ThreadLocal.withInitial(() -> true);
    private final Set<AbstractConfigurationObject> children = new LinkedHashSet<AbstractConfigurationObject>();
    protected final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public AbstractConfigurationObject() {
        this.id = UUID.randomUUID().toString();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public abstract String getType();

    protected void markAsDirty() {
        if (!trackObjectChanges.get().booleanValue()) {
            return;
        }
        this.dirty = true;
        this.notifyChange();
    }

    protected void deepMarkAsDirty() {
        if (!trackObjectChanges.get().booleanValue()) {
            return;
        }
        this.dirty = true;
        this.children.forEach(AbstractConfigurationObject::deepMarkAsDirty);
    }

    protected void addChild(AbstractConfigurationObject configurationObject) {
        Objects.requireNonNull(configurationObject, "Child configuration object must not be null");
        this.children.add(configurationObject);
        configurationObject.addPropertyChangeListener(this::notifyChange);
        this.markAsDirty();
        configurationObject.deepMarkAsDirty();
    }

    protected void addNullableChild(AbstractConfigurationObject configurationObject) {
        if (configurationObject == null) {
            return;
        }
        this.addChild(configurationObject);
    }

    protected void removeChild(AbstractConfigurationObject configurationObject) {
        if (configurationObject == null) {
            return;
        }
        this.children.remove(configurationObject);
        configurationObject.removePropertyChangeListener(this::notifyChange);
        this.markAsDirty();
    }

    protected void notifyChange() {
        if (!trackObjectChanges.get().booleanValue()) {
            return;
        }
        this.propertyChangeSupport.firePropertyChange("property", null, null);
    }

    protected void notifyChange(PropertyChangeEvent event) {
        if (!trackObjectChanges.get().booleanValue()) {
            return;
        }
        this.propertyChangeSupport.firePropertyChange("property", null, null);
    }

    protected void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    protected void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    protected void update(Runnable updater, boolean trackObjectChanges) {
        AbstractConfigurationObject.trackObjectChanges.set(trackObjectChanges);
        try {
            updater.run();
        }
        finally {
            AbstractConfigurationObject.trackObjectChanges.remove();
        }
    }

    protected void collectChanges(Consumer<AbstractConfigurationObject> changeCollector) {
        this.children.forEach(child -> child.collectChanges(changeCollector));
        if (this.dirty) {
            changeCollector.accept(this);
            this.dirty = false;
        }
    }
}

