/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.map;

import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.map.MapBase;
import com.vaadin.flow.component.map.configuration.Configuration;
import com.vaadin.flow.component.map.configuration.Coordinate;
import com.vaadin.flow.component.map.configuration.layer.FeatureLayer;
import com.vaadin.flow.component.map.configuration.layer.Layer;
import com.vaadin.flow.component.map.configuration.layer.TileLayer;
import com.vaadin.flow.component.map.configuration.source.OSMSource;
import java.io.Serializable;
import java.util.Objects;

@Tag(value="vaadin-map")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/map", version="24.4.13"), @NpmPackage(value="proj4", version="2.11.0")})
@JsModule.Container(value={@JsModule(value="@vaadin/map/src/vaadin-map.js"), @JsModule(value="./vaadin-map/mapConnector.js")})
public class Map
extends MapBase {
    private Layer backgroundLayer;
    private final FeatureLayer featureLayer;

    public static void setUserProjection(String projection) {
        UI ui = UI.getCurrent();
        if (ui == null || ui.getPage() == null) {
            throw new IllegalStateException("UI instance is not available. It means that you are calling this method out of a normal workflow where it's always implicitly set. That may happen if you call the method from the custom thread without 'UI::access' or from tests without proper initialization.");
        }
        UI.getCurrent().getPage().executeJs("window.Vaadin.Flow.mapConnector.setUserProjection($0)", new Serializable[]{projection});
    }

    public static void defineProjection(String projectionName, String wksDefinition) {
        UI ui = UI.getCurrent();
        if (ui == null || ui.getPage() == null) {
            throw new IllegalStateException("UI instance is not available. It means that you are calling this method out of a normal workflow where it's always implicitly set. That may happen if you call the method from the custom thread without 'UI::access' or from tests without proper initialization.");
        }
        UI.getCurrent().getPage().executeJs("window.Vaadin.Flow.mapConnector.defineProjection($0, $1)", new Serializable[]{projectionName, wksDefinition});
    }

    public Map() {
        OSMSource source = new OSMSource();
        TileLayer backgroundLayer = new TileLayer();
        backgroundLayer.setSource(source);
        this.setBackgroundLayer(backgroundLayer);
        this.featureLayer = new FeatureLayer();
        this.addLayer(this.featureLayer);
        this.featureLayer.setzIndex(100);
    }

    public Configuration getRawConfiguration() {
        return this.getConfiguration();
    }

    public Layer getBackgroundLayer() {
        return this.backgroundLayer;
    }

    public void setBackgroundLayer(Layer backgroundLayer) {
        Objects.requireNonNull(backgroundLayer);
        if (this.backgroundLayer != null) {
            this.getConfiguration().removeLayer(this.backgroundLayer);
        }
        this.backgroundLayer = backgroundLayer;
        this.getConfiguration().prependLayer(backgroundLayer);
    }

    public FeatureLayer getFeatureLayer() {
        return this.featureLayer;
    }

    public void addLayer(Layer layer) {
        this.getConfiguration().addLayer(layer);
    }

    public void removeLayer(Layer layer) {
        this.getConfiguration().removeLayer(layer);
    }

    public Coordinate getCenter() {
        return this.getView().getCenter();
    }

    public void setCenter(Coordinate center) {
        this.getView().setCenter(center);
    }

    public double getZoom() {
        return this.getView().getZoom();
    }

    public void setZoom(double zoom) {
        this.getView().setZoom(zoom);
    }
}

