/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.map.configuration.feature;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.vaadin.flow.component.map.Assets;
import com.vaadin.flow.component.map.configuration.Coordinate;
import com.vaadin.flow.component.map.configuration.feature.PointBasedFeature;
import com.vaadin.flow.component.map.configuration.style.Icon;
import com.vaadin.flow.component.map.configuration.style.Style;
import java.util.Objects;

public class MarkerFeature
extends PointBasedFeature {
    public static final Icon PIN_ICON;
    public static final Icon POINT_ICON;

    public MarkerFeature() {
        this(new Coordinate(0.0, 0.0), PIN_ICON);
    }

    public MarkerFeature(Coordinate coordinates) {
        this(coordinates, PIN_ICON);
    }

    public MarkerFeature(Coordinate coordinates, Icon icon) {
        super(coordinates);
        Objects.requireNonNull(coordinates);
        Objects.requireNonNull(icon);
        Style style = new Style();
        this.setStyle(style);
        this.setIcon(icon);
    }

    @JsonIgnore
    public Icon getIcon() {
        return (Icon)this.getStyle().getImage();
    }

    public void setIcon(Icon icon) {
        Objects.requireNonNull(icon);
        this.getStyle().setImage(icon);
    }

    static {
        Icon.ImageSize pinImageSize = new Icon.ImageSize(Assets.PIN.getWidth(), Assets.PIN.getHeight());
        Icon.Options pinIconOptions = new Icon.Options();
        pinIconOptions.setImg(Assets.PIN.getResource());
        pinIconOptions.setImgSize(pinImageSize);
        pinIconOptions.setScale(0.5);
        pinIconOptions.setAnchorOrigin(Icon.AnchorOrigin.BOTTOM_LEFT);
        pinIconOptions.setAnchor(new Icon.Anchor(0.5, 0.12f));
        PIN_ICON = new Icon(pinIconOptions);
        Icon.ImageSize pointImageSize = new Icon.ImageSize(Assets.POINT.getWidth(), Assets.POINT.getHeight());
        Icon.Options pointIconOptions = new Icon.Options();
        pointIconOptions.setImg(Assets.POINT.getResource());
        pointIconOptions.setImgSize(pointImageSize);
        pointIconOptions.setScale(0.25);
        pointIconOptions.setAnchorOrigin(Icon.AnchorOrigin.TOP_LEFT);
        pointIconOptions.setAnchor(new Icon.Anchor(0.5, 0.5));
        POINT_ICON = new Icon(pointIconOptions);
    }
}

