/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.map.configuration.feature;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.vaadin.flow.component.map.configuration.Coordinate;
import com.vaadin.flow.component.map.configuration.Feature;
import com.vaadin.flow.component.map.configuration.geometry.Point;
import com.vaadin.flow.component.map.configuration.geometry.SimpleGeometry;
import java.util.Objects;

public abstract class PointBasedFeature
extends Feature {
    protected PointBasedFeature() {
        this(new Coordinate(0.0, 0.0));
    }

    protected PointBasedFeature(Coordinate coordinates) {
        Objects.requireNonNull(coordinates);
        this.setGeometry(new Point(coordinates));
    }

    @JsonIgnore
    public Coordinate getCoordinates() {
        return this.getGeometry().getCoordinates();
    }

    public void setCoordinates(Coordinate coordinates) {
        Objects.requireNonNull(coordinates);
        this.getGeometry().setCoordinates(coordinates);
    }

    @Override
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonIdentityReference(alwaysAsId=true)
    public Point getGeometry() {
        return (Point)super.getGeometry();
    }

    @Override
    public void setGeometry(SimpleGeometry geometry) {
        Objects.requireNonNull(geometry);
        if (!(geometry instanceof Point)) {
            throw new IllegalArgumentException("Geometry must be a point");
        }
        super.setGeometry(geometry);
    }
}

