/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.map.configuration.style;

import com.vaadin.flow.component.map.configuration.style.ImageStyle;
import com.vaadin.flow.server.StreamResource;
import java.io.Serializable;

public class Icon
extends ImageStyle {
    private Anchor anchor;
    private final AnchorOrigin anchorOrigin;
    private final String color;
    private final String crossOrigin;
    private final String src;
    private final StreamResource img;
    private final ImageSize imgSize;

    @Override
    public String getType() {
        return "ol/style/Icon";
    }

    public Anchor getAnchor() {
        return this.anchor;
    }

    public void setAnchor(Anchor anchor) {
        this.anchor = anchor;
        this.markAsDirty();
    }

    public AnchorOrigin getAnchorOrigin() {
        return this.anchorOrigin;
    }

    public String getColor() {
        return this.color;
    }

    public String getCrossOrigin() {
        return this.crossOrigin;
    }

    public String getSrc() {
        return this.src;
    }

    public StreamResource getImg() {
        return this.img;
    }

    public ImageSize getImgSize() {
        return this.imgSize;
    }

    public Icon(Options options) {
        super(options);
        if (options.src == null && options.img == null) {
            throw new NullPointerException("Either a source URL or an image must be specified in the options");
        }
        if (options.src != null && options.img != null) {
            throw new IllegalStateException("Both a source URL or an image were specified in the options. You must only specify one of these options.");
        }
        this.anchor = options.anchor;
        this.anchorOrigin = options.anchorOrigin;
        this.color = options.color;
        this.crossOrigin = options.crossOrigin;
        this.src = options.src;
        this.img = options.img;
        this.imgSize = options.imgSize;
    }

    public static class ImageSize
    implements Serializable {
        int width;
        int height;

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public ImageSize(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }

    public static enum AnchorOrigin {
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        TOP_LEFT,
        TOP_RIGHT;

    }

    public static class Anchor
    implements Serializable {
        private float x = 0.5f;
        private float y = 0.5f;

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public Anchor() {
        }

        public Anchor(float x, float y) {
            this.x = x;
            this.y = y;
        }
    }

    public static class Options
    extends ImageStyle.Options {
        private Anchor anchor = new Anchor();
        private AnchorOrigin anchorOrigin = AnchorOrigin.TOP_LEFT;
        private String color;
        private String crossOrigin;
        private String src;
        private StreamResource img;
        private ImageSize imgSize;

        public void setAnchor(Anchor anchor) {
            this.anchor = anchor;
        }

        public void setAnchorOrigin(AnchorOrigin anchorOrigin) {
            this.anchorOrigin = anchorOrigin;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public void setCrossOrigin(String crossOrigin) {
            this.crossOrigin = crossOrigin;
        }

        public void setSrc(String src) {
            this.src = src;
        }

        public void setImg(StreamResource img) {
            this.img = img;
        }

        public void setImgSize(ImageSize imgSize) {
            this.imgSize = imgSize;
        }
    }
}

