/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.map.configuration;

import com.vaadin.flow.component.map.configuration.Projection;
import java.io.Serializable;
import java.util.Objects;

public class Coordinate
implements Serializable {
    private final double x;
    private final double y;

    public Coordinate() {
        this(0.0, 0.0);
    }

    public Coordinate(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public String toString() {
        return "Coordinate{x=" + this.x + ", y=" + this.y + "}";
    }

    public static Coordinate fromLonLat(double longitude, double latitude) {
        return Coordinate.fromLonLat(longitude, latitude, Projection.EPSG_3857);
    }

    public static Coordinate fromLonLat(double longitude, double latitude, Projection targetProjection) {
        Objects.requireNonNull(targetProjection);
        switch (targetProjection) {
            case EPSG_3857: {
                return Converters.epsg_4326_to_epsg_3857(new Coordinate(longitude, latitude));
            }
        }
        throw new IllegalArgumentException("Unsupported projection: " + targetProjection.stringValue());
    }

    private static class Converters {
        private static final double RADIUS = 6378137.0;
        private static final double HALF_SIZE = 2.0037508342789244E7;
        private static final double MAX_SAFE_Y = 6378137.0 * Math.log(Math.tan(1.5707963267948966));

        private Converters() {
        }

        private static Coordinate epsg_4326_to_epsg_3857(Coordinate coordinate) {
            double x = 2.0037508342789244E7 * coordinate.x / 180.0;
            double y = 6378137.0 * Math.log(Math.tan(Math.PI * (coordinate.y + 90.0) / 360.0));
            if (y > MAX_SAFE_Y) {
                y = MAX_SAFE_Y;
            } else if (y < -MAX_SAFE_Y) {
                y = -MAX_SAFE_Y;
            }
            return new Coordinate(x, y);
        }
    }
}

