/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.map.configuration.source;

import com.vaadin.flow.component.map.configuration.AbstractConfigurationObject;
import java.util.List;
import java.util.Objects;

public abstract class Source
extends AbstractConfigurationObject {
    private List<String> attributions;
    private final boolean attributionsCollapsible;
    private final String projection;

    protected Source(BaseOptions<?> options) {
        Objects.requireNonNull(options);
        this.attributions = options.attributions;
        this.attributionsCollapsible = options.attributionsCollapsible;
        this.projection = options.projection;
    }

    public List<String> getAttributions() {
        return this.attributions;
    }

    public void setAttributions(List<String> attributions) {
        this.attributions = attributions;
        this.markAsDirty();
    }

    public boolean isAttributionsCollapsible() {
        return this.attributionsCollapsible;
    }

    public String getProjection() {
        return this.projection;
    }

    protected static class BaseOptions<T extends BaseOptions<T>> {
        private List<String> attributions;
        private boolean attributionsCollapsible = true;
        private String projection;

        protected BaseOptions() {
        }

        protected T getThis() {
            return (T)this;
        }

        public T setAttributions(List<String> attributions) {
            this.attributions = attributions;
            return this.getThis();
        }

        public T setAttributionsCollapsible(boolean attributionsCollapsible) {
            this.attributionsCollapsible = attributionsCollapsible;
            return this.getThis();
        }

        public T setProjection(String projection) {
            this.projection = projection;
            return this.getThis();
        }
    }
}

