/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.map.configuration.style;

import com.vaadin.flow.component.map.configuration.style.ImageStyle;
import com.vaadin.flow.server.StreamResource;

public class Icon
extends ImageStyle {
    private Anchor anchor;
    private final AnchorOrigin anchorOrigin;
    private final String color;
    private final String crossOrigin;
    private final String src;
    private final StreamResource img;
    private final ImageSize imgSize;

    @Override
    public String getType() {
        return "ol/style/Icon";
    }

    public Anchor getAnchor() {
        return this.anchor;
    }

    public void setAnchor(Anchor anchor) {
        this.anchor = anchor;
        this.markAsDirty();
    }

    public AnchorOrigin getAnchorOrigin() {
        return this.anchorOrigin;
    }

    public String getColor() {
        return this.color;
    }

    public String getCrossOrigin() {
        return this.crossOrigin;
    }

    public String getSrc() {
        return this.src;
    }

    public StreamResource getImg() {
        return this.img;
    }

    public ImageSize getImgSize() {
        return this.imgSize;
    }

    public Icon(Options options) {
        super(options);
        if (options.src == null && options.img == null) {
            throw new NullPointerException("Either a source URL or an image must be specified in the options");
        }
        if (options.src != null && options.img != null) {
            throw new IllegalStateException("Both a source URL or an image were specified in the options. You must only specify one of these options.");
        }
        this.anchor = options.anchor;
        this.anchorOrigin = options.anchorOrigin;
        this.color = options.color;
        this.crossOrigin = options.crossOrigin;
        this.src = options.src;
        this.img = options.img;
        this.imgSize = options.imgSize;
    }

    public static class ImageSize {
        int width;
        int height;

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public ImageSize(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }

    public static enum AnchorOrigin {
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        TOP_LEFT,
        TOP_RIGHT;

    }

    public static class Anchor {
        private float x = 0.5f;
        private float y = 0.5f;

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public Anchor() {
        }

        public Anchor(float x, float y) {
            this.x = x;
            this.y = y;
        }
    }

    public static class Options
    extends ImageStyle.BaseOptions<Options> {
        private Anchor anchor = new Anchor();
        private AnchorOrigin anchorOrigin = AnchorOrigin.TOP_LEFT;
        private String color;
        private String crossOrigin;
        private String src;
        private StreamResource img;
        private ImageSize imgSize;

        public Options setAnchor(Anchor anchor) {
            this.anchor = anchor;
            return (Options)this.getThis();
        }

        public Options setAnchorOrigin(AnchorOrigin anchorOrigin) {
            this.anchorOrigin = anchorOrigin;
            return (Options)this.getThis();
        }

        public Options setColor(String color) {
            this.color = color;
            return (Options)this.getThis();
        }

        public Options setCrossOrigin(String crossOrigin) {
            this.crossOrigin = crossOrigin;
            return (Options)this.getThis();
        }

        public Options setSrc(String src) {
            this.src = src;
            return (Options)this.getThis();
        }

        public Options setImg(StreamResource img) {
            this.img = img;
            return (Options)this.getThis();
        }

        public Options setImgSize(ImageSize imgSize) {
            this.imgSize = imgSize;
            return (Options)this.getThis();
        }
    }
}

