/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.map;

import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.map.MapBase;
import com.vaadin.flow.component.map.configuration.Configuration;
import com.vaadin.flow.component.map.configuration.Coordinate;
import com.vaadin.flow.component.map.configuration.layer.FeatureLayer;
import com.vaadin.flow.component.map.configuration.layer.Layer;
import com.vaadin.flow.component.map.configuration.layer.TileLayer;
import com.vaadin.flow.component.map.configuration.source.OSMSource;
import java.util.Objects;

@Tag(value="vaadin-map")
@NpmPackage(value="@vaadin/map", version="23.0.14")
@JsModule.Container(value={@JsModule(value="@vaadin/map/src/vaadin-map.js"), @JsModule(value="./vaadin-map/mapConnector.js")})
public class Map
extends MapBase {
    private Layer backgroundLayer;
    private final FeatureLayer featureLayer;

    public Map() {
        OSMSource source = new OSMSource();
        TileLayer backgroundLayer = new TileLayer();
        backgroundLayer.setSource(source);
        this.setBackgroundLayer(backgroundLayer);
        this.featureLayer = new FeatureLayer();
        this.addLayer(this.featureLayer);
        this.featureLayer.setzIndex(100);
    }

    public Configuration getRawConfiguration() {
        return this.getConfiguration();
    }

    public Layer getBackgroundLayer() {
        return this.backgroundLayer;
    }

    public void setBackgroundLayer(Layer backgroundLayer) {
        Objects.requireNonNull(backgroundLayer);
        if (this.backgroundLayer != null) {
            this.getConfiguration().removeLayer(this.backgroundLayer);
        }
        this.backgroundLayer = backgroundLayer;
        this.getConfiguration().prependLayer(backgroundLayer);
    }

    public FeatureLayer getFeatureLayer() {
        return this.featureLayer;
    }

    public void addLayer(Layer layer) {
        this.getConfiguration().addLayer(layer);
    }

    public void removeLayer(Layer layer) {
        this.getConfiguration().removeLayer(layer);
    }

    public Coordinate getCenter() {
        return this.getView().getCenter();
    }

    public void setCenter(Coordinate center) {
        this.getView().setCenter(center);
    }

    public float getZoom() {
        return this.getView().getZoom();
    }

    public void setZoom(float zoom) {
        this.getView().setZoom(zoom);
    }
}

