/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid.testbench;

import com.vaadin.flow.component.grid.testbench.GridColumnElement;
import com.vaadin.flow.component.grid.testbench.GridTHTDElement;
import com.vaadin.flow.component.grid.testbench.GridTRElement;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elementsbase.Element;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

@Element(value="vaadin-grid")
public class GridElement
extends TestBenchElement {
    protected void waitUntilLoadingFinished() {
        this.waitUntil(e -> !this.isLoading());
    }

    protected boolean isLoading() {
        return (Boolean)this.executeScript("return arguments[0]._cache.isLoading() || (arguments[0].$connector && arguments[0].$connector.hasRootRequestQueue())", new Object[]{this});
    }

    public void scrollToRow(int row) {
        this.callFunction("_scrollToIndex", new Object[]{row});
        this.waitUntilLoadingFinished();
    }

    public int getPageSize() {
        return this.getPropertyInteger(new String[]{"pageSize"});
    }

    public int getFirstVisibleRowIndex() {
        return ((Long)this.executeScript("return arguments[0]._firstVisibleIndex+arguments[0]._vidxOffset", new Object[]{this})).intValue();
    }

    public int getRowCount() {
        this.waitUntilLoadingFinished();
        return this.getPropertyDouble(new String[]{"_effectiveSize"}).intValue();
    }

    public GridTHTDElement getCell(int rowIndex, int colIndex) {
        GridColumnElement column = this.getVisibleColumns().get(colIndex);
        return this.getCell(rowIndex, column);
    }

    public GridTHTDElement getCell(int rowIndex, GridColumnElement column) {
        if (!this.isRowInView(rowIndex)) {
            this.scrollToRow(rowIndex);
        }
        GridTRElement row = this.getRow(rowIndex);
        return row.getCell(column);
    }

    public GridTHTDElement getCell(String contents) throws NoSuchElementException {
        String script = "const grid = arguments[0];const contents = arguments[1];const rowsInDom = Array.from(arguments[0].$.items.children);var tds = [];rowsInDom.forEach(function(tr) { Array.from(tr.children).forEach(function(td) { tds.push(td);})});const matches = tds.filter(function(td) { return td._content.textContent == contents});return matches.length ? matches[0] : null;";
        TestBenchElement td = (TestBenchElement)this.executeScript(script, new Object[]{this, contents});
        if (td == null) {
            throw new NoSuchElementException("No cell with text content '" + contents + "' found");
        }
        return (GridTHTDElement)td.wrap(GridTHTDElement.class);
    }

    public int getLastVisibleRowIndex() {
        return ((Long)this.executeScript("return arguments[0]._lastVisibleIndex+arguments[0]._vidxOffset", new Object[]{this})).intValue();
    }

    private boolean isRowInView(int rowIndex) {
        return this.getFirstVisibleRowIndex() <= rowIndex && rowIndex <= this.getLastVisibleRowIndex();
    }

    public GridTRElement getRow(int rowIndex) {
        String script = "var grid = arguments[0];var rowIndex = arguments[1];var rowsInDom = grid.$.items.children;var rowInDom = Array.from(rowsInDom).filter(function(row) { return !row.hidden && row.index == rowIndex;})[0];return rowInDom;";
        return (GridTRElement)((TestBenchElement)this.executeScript(script, new Object[]{this, rowIndex})).wrap(GridTRElement.class);
    }

    public List<GridColumnElement> getAllColumns() {
        this.generatedColumnIdsIfNeeded();
        String getVisibleColumnsJS = "return arguments[0]._getColumns().sort(function(a,b) { return a._order - b._order;}).map(function(column) { return column.__generatedTbId;});";
        List elements = (List)this.executeScript(getVisibleColumnsJS, new Object[]{this});
        return elements.stream().map(generatedId -> new GridColumnElement((Long)generatedId, this)).collect(Collectors.toList());
    }

    protected void generatedColumnIdsIfNeeded() {
        String generateIds = "const grid = arguments[0];if (!grid.__generatedTbId) {  grid.__generatedTbId = 1;}grid._getColumns().forEach(function(column) {  if (!column.__generatedTbId) {    column.__generatedTbId = grid.__generatedTbId++;  }});";
        this.executeScript(generateIds, new Object[]{this});
    }

    public List<GridColumnElement> getVisibleColumns() {
        this.generatedColumnIdsIfNeeded();
        String getVisibleColumnsJS = "return arguments[0]._getColumns().filter(function(column) {return !column.hidden;}).sort(function(a,b) { return a._order - b._order;}).map(function(column) { return column.__generatedTbId;});";
        List elements = (List)this.executeScript(getVisibleColumnsJS, new Object[]{this});
        return elements.stream().map(id -> new GridColumnElement((Long)id, this)).collect(Collectors.toList());
    }

    public GridColumnElement getColumn(String headerText) throws NoSuchElementException {
        return this.getVisibleColumns().stream().filter(column -> headerText.equals(column.getHeaderCell().getText())).findFirst().orElseThrow(() -> new NoSuchElementException("No column with header '" + headerText + "' was found"));
    }

    public GridTHTDElement getHeaderCell(int columnIndex) {
        return this.getVisibleColumns().get(columnIndex).getHeaderCell();
    }

    public TestBenchElement getHeaderCellContent(int rowIndex, int columnIndex) {
        WebElement thead = this.findInShadowRoot(By.id((String)"header")).get(0);
        List headerRows = thead.findElements(By.tagName((String)"tr"));
        List headerCells = ((WebElement)headerRows.get(rowIndex)).findElements(By.tagName((String)"th"));
        String slotName = ((WebElement)headerCells.get(columnIndex)).findElement(By.tagName((String)"slot")).getAttribute("name");
        return this.findElement(By.cssSelector((String)("vaadin-grid-cell-content[slot='" + slotName + "']")));
    }

    public List<WebElement> findInShadowRoot(By by) {
        return this.getShadowRoot().findElements(by);
    }

    private WebElement getShadowRoot() {
        this.waitUntil(driver -> this.getCommandExecutor().executeScript("return arguments[0].shadowRoot", new Object[]{this}) != null);
        WebElement shadowRoot = (WebElement)this.getCommandExecutor().executeScript("return arguments[0].shadowRoot", new Object[]{this});
        Assert.assertNotNull((String)"Could not locate shadowRoot in the element", (Object)shadowRoot);
        return shadowRoot;
    }

    public GridTHTDElement getFooterCell(int columnIndex) {
        return this.getVisibleColumns().get(columnIndex).getFooterCell();
    }

    public void select(int rowIndex) {
        this.select(this.getRow(rowIndex));
    }

    void select(GridTRElement row) {
        if (this.isMultiselect()) {
            this.executeScript("arguments[0].selectItem(arguments[1]._item);", new Object[]{this, row});
        } else {
            this.setActiveItem(row);
        }
    }

    public void deselect(int rowIndex) {
        this.deselect(this.getRow(rowIndex));
    }

    void deselect(GridTRElement row) {
        if (this.isMultiselect()) {
            this.executeScript("arguments[0].deselectItem(arguments[1]._item);", new Object[]{this, row});
        } else {
            this.removeActiveItem(row);
        }
    }

    private void setActiveItem(GridTRElement row) {
        this.executeScript("arguments[0].activeItem=arguments[1]._item", new Object[]{this, row});
    }

    private void removeActiveItem(GridTRElement row) {
        this.executeScript("if(arguments[0].activeItem == arguments[1]._item) { arguments[0].activeItem=null;}", new Object[]{this, row});
    }

    private boolean isMultiselect() {
        return (Boolean)this.executeScript("return arguments[0]._getColumns().filter(function(col) { return typeof col.selectAll != 'undefined';}).length > 0", new Object[]{this});
    }
}

