/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid.testbench;

import com.vaadin.flow.component.checkbox.testbench.CheckboxElement;
import com.vaadin.flow.component.grid.testbench.GridColumnElement;
import com.vaadin.flow.component.grid.testbench.GridTHTDElement;
import com.vaadin.flow.component.grid.testbench.GridTRElement;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.commands.TestBenchCommandExecutor;
import com.vaadin.testbench.elementsbase.Element;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

@Element(value="vaadin-grid")
public class GridElement
extends TestBenchElement {
    protected void waitUntilLoadingFinished() {
        this.waitUntil(e -> !this.isLoading());
    }

    protected boolean isLoading() {
        return (Boolean)this.executeScript("return arguments[0]._dataProviderController.isLoading() || (!!arguments[0].$connector && arguments[0].$connector.hasRootRequestQueue())", new Object[]{this});
    }

    public void scrollToRow(int row) {
        this.callFunction("scrollToIndex", new Object[]{row});
        this.waitUntilLoadingFinished();
    }

    protected void scrollToFlatRow(int row) {
        this.callFunction("_scrollToFlatIndex", new Object[]{row});
        this.waitUntilLoadingFinished();
    }

    public int getPageSize() {
        return this.getPropertyInteger(new String[]{"pageSize"});
    }

    public int getFirstVisibleRowIndex() {
        Object index = this.executeScript("return arguments[0]._firstVisibleIndex", new Object[]{this});
        if (index != null) {
            return ((Long)index).intValue();
        }
        return -1;
    }

    public int getRowCount() {
        this.waitUntilLoadingFinished();
        return this.getPropertyDouble(new String[]{"_flatSize"}).intValue();
    }

    public GridTHTDElement getCell(int rowIndex, int colIndex) {
        GridColumnElement column = this.getVisibleColumns().get(colIndex);
        return this.getCell(rowIndex, column);
    }

    public GridTHTDElement getCell(int rowIndex, GridColumnElement column) {
        if (!this.isRowInView(rowIndex)) {
            this.scrollToFlatRow(rowIndex);
        }
        GridTRElement row = this.getRow(rowIndex);
        return row.getCell(column);
    }

    public GridTHTDElement getCell(String contents) throws NoSuchElementException {
        String script = "const grid = arguments[0];const contents = arguments[1];const rowsInDom = Array.from(arguments[0].$.items.children);var tds = [];rowsInDom.forEach(function(tr) { Array.from(tr.children).forEach(function(td) { tds.push(td);})});const matches = tds.filter(function(td) { return td._content.textContent == contents});return matches.length ? matches[0] : null;";
        TestBenchElement td = (TestBenchElement)this.executeScript(script, new Object[]{this, contents});
        if (td == null) {
            throw new NoSuchElementException("No cell with text content '" + contents + "' found");
        }
        return (GridTHTDElement)td.wrap(GridTHTDElement.class);
    }

    public int getLastVisibleRowIndex() {
        Object index = this.executeScript("return arguments[0]._lastVisibleIndex", new Object[]{this});
        if (index != null) {
            return ((Long)index).intValue();
        }
        return -1;
    }

    private boolean isRowInView(int rowIndex) {
        return this.getFirstVisibleRowIndex() <= rowIndex && rowIndex <= this.getLastVisibleRowIndex();
    }

    public List<GridTRElement> getRows(int firstRowIndex, int lastRowIndex) throws IndexOutOfBoundsException {
        int rowCount = this.getRowCount();
        if (firstRowIndex < 0 || lastRowIndex < 0 || firstRowIndex >= rowCount || lastRowIndex >= rowCount) {
            throw new IndexOutOfBoundsException("firstRowIndex and lastRowIndex: expected to be 0.." + (rowCount - 1) + " but were " + firstRowIndex + " and " + lastRowIndex);
        }
        String script = "var grid = arguments[0];var firstRowIndex = arguments[1];var lastRowIndex = arguments[2];var rowsInDom = grid._getRenderedRows();return Array.from(rowsInDom).filter((row) => { return row.index >= firstRowIndex && row.index <= lastRowIndex;});";
        Object rows = this.executeScript(script, new Object[]{this, firstRowIndex, lastRowIndex});
        if (rows != null) {
            return ((ArrayList)rows).stream().map(elem -> (GridTRElement)((TestBenchElement)elem).wrap(GridTRElement.class)).toList();
        }
        return new ArrayList<GridTRElement>();
    }

    public GridTRElement getRow(int rowIndex) throws IndexOutOfBoundsException {
        List<GridTRElement> rows = this.getRows(rowIndex, rowIndex);
        return rows.size() == 1 ? rows.get(0) : null;
    }

    public List<GridColumnElement> getAllColumns() {
        this.generatedColumnIdsIfNeeded();
        String getVisibleColumnsJS = "return arguments[0]._getColumns().sort(function(a,b) { return a._order - b._order;}).map(function(column) { return column.__generatedTbId;});";
        List elements = (List)this.executeScript(getVisibleColumnsJS, new Object[]{this});
        return elements.stream().map(generatedId -> new GridColumnElement((Long)generatedId, this)).collect(Collectors.toList());
    }

    protected void generatedColumnIdsIfNeeded() {
        String generateIds = "const grid = arguments[0];if (!grid.__generatedTbId) {  grid.__generatedTbId = 1;}grid._getColumns().forEach(function(column) {  if (!column.__generatedTbId) {    column.__generatedTbId = grid.__generatedTbId++;  }});";
        this.executeScript(generateIds, new Object[]{this});
    }

    public List<GridColumnElement> getVisibleColumns() {
        this.generatedColumnIdsIfNeeded();
        String getVisibleColumnsJS = "return arguments[0]._getColumns().filter(function(column) {return !column.hidden;}).sort(function(a,b) { return a._order - b._order;}).map(function(column) { return column.__generatedTbId;});";
        List elements = (List)this.executeScript(getVisibleColumnsJS, new Object[]{this});
        return elements.stream().map(id -> new GridColumnElement((Long)id, this)).collect(Collectors.toList());
    }

    public GridColumnElement getColumn(String headerText) throws NoSuchElementException {
        return this.getVisibleColumns().stream().filter(column -> headerText.equals(column.getHeaderCell().getText())).findFirst().orElseThrow(() -> new NoSuchElementException("No column with header '" + headerText + "' was found"));
    }

    public GridTHTDElement getHeaderCell(int columnIndex) {
        return this.getVisibleColumns().get(columnIndex).getHeaderCell();
    }

    public TestBenchElement getHeaderCellContent(int rowIndex, int columnIndex) {
        TestBenchElement thead = this.$("*").id("header");
        List headerRows = thead.findElements(By.tagName((String)"tr"));
        List headerCells = ((WebElement)headerRows.get(rowIndex)).findElements(By.tagName((String)"th"));
        String slotName = ((WebElement)headerCells.get(columnIndex)).findElement(By.tagName((String)"slot")).getDomAttribute("name");
        return this.findElement(By.cssSelector((String)("vaadin-grid-cell-content[slot='" + slotName + "']")));
    }

    public GridTHTDElement getFooterCell(int columnIndex) {
        return this.getVisibleColumns().get(columnIndex).getFooterCell();
    }

    public void select(int rowIndex) {
        this.select(this.getRow(rowIndex));
    }

    void select(GridTRElement row) {
        GridColumnElement multiSelectColumn = this.getMultiSelectColumn();
        if (multiSelectColumn != null) {
            GridTHTDElement cell = row.getCell(multiSelectColumn);
            CheckboxElement checkbox = (CheckboxElement)GridElement.wrapElement((WebElement)cell.getFirstChildElement(), (TestBenchCommandExecutor)this.getCommandExecutor()).wrap(CheckboxElement.class);
            if (!checkbox.isChecked()) {
                checkbox.getWrappedElement().click();
            }
        } else {
            this.setActiveItem(row);
        }
    }

    public void deselect(int rowIndex) {
        this.deselect(this.getRow(rowIndex));
    }

    void deselect(GridTRElement row) {
        GridColumnElement multiSelectColumn = this.getMultiSelectColumn();
        if (multiSelectColumn != null) {
            GridTHTDElement cell = row.getCell(multiSelectColumn);
            CheckboxElement checkbox = (CheckboxElement)GridElement.wrapElement((WebElement)cell.getFirstChildElement(), (TestBenchCommandExecutor)this.getCommandExecutor()).wrap(CheckboxElement.class);
            if (checkbox.isChecked()) {
                checkbox.getWrappedElement().click();
            }
        } else {
            this.removeActiveItem(row);
        }
    }

    private void setActiveItem(GridTRElement row) {
        this.executeScript("arguments[0].activeItem=arguments[1]._item", new Object[]{this, row});
    }

    private void removeActiveItem(GridTRElement row) {
        String JS_DEACTIVATE_IF_ACTIVE = "if(arguments[0]._itemsEqual(arguments[0].activeItem, arguments[1]._item)) { arguments[0].activeItem=null;}";
        this.executeScript("if(arguments[0]._itemsEqual(arguments[0].activeItem, arguments[1]._item)) { arguments[0].activeItem=null;}", new Object[]{this, row});
    }

    private GridColumnElement getMultiSelectColumn() {
        this.generatedColumnIdsIfNeeded();
        List columnIds = (List)this.executeScript("return arguments[0]._getColumns().filter(function(col) { return typeof col.selectAll != 'undefined';}).map(function(column) { return column.__generatedTbId;});", new Object[]{this});
        if (columnIds.isEmpty()) {
            return null;
        }
        return new GridColumnElement((Long)columnIds.get(0), this);
    }

    public void clickSelectAll() {
        CheckboxElement selectAllCheckbox = (CheckboxElement)this.$(CheckboxElement.class).id("selectAllCheckbox");
        selectAllCheckbox.click();
    }

    public List<GridTRElement> getVisibleRows() {
        return this.getRows(this.getFirstVisibleRowIndex(), this.getLastVisibleRowIndex());
    }

    public List<GridTHTDElement> getCells(int rowIndex, GridColumnElement ... columnElements) {
        GridTRElement row = this.getRow(rowIndex);
        return row != null ? row.getCells(columnElements) : new ArrayList();
    }

    public List<GridTHTDElement> getCells(int rowIndex) {
        return this.getCells(rowIndex, this.getAllColumns().toArray(new GridColumnElement[0]));
    }

    public TestBenchElement getEmptyStateContent() {
        try {
            return this.findElement(By.cssSelector((String)"[slot='empty-state']"));
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException("No empty state content was found");
        }
    }
}

