/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid.testbench;

import com.vaadin.flow.component.grid.testbench.GridColumnElement;
import com.vaadin.flow.component.grid.testbench.GridElement;
import com.vaadin.flow.component.grid.testbench.GridTRElement;
import com.vaadin.testbench.TestBenchElement;
import java.util.List;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class GridTHTDElement
extends TestBenchElement {
    public String getText() {
        String text = (String)this.executeScript("var cell = arguments[0];return Array.from(cell.firstElementChild.assignedNodes()).map(function(node) { return node.textContent;}).join('');", new Object[]{this});
        if (text.trim().isEmpty()) {
            return "";
        }
        return text;
    }

    public String getInnerHTML() {
        String text = (String)this.executeScript("var cell = arguments[0];return Array.from(cell.firstElementChild.assignedNodes()).map(function(node) { return node.innerHTML;}).join('');", new Object[]{this});
        if (text.trim().isEmpty()) {
            return "";
        }
        return text;
    }

    protected static String getSlotText(TestBenchElement slot) {
        List content = (List)slot.callFunction("assignedNodes", new Object[0]);
        StringBuilder text = new StringBuilder();
        content.forEach(element -> text.append(element.getText()));
        return text.toString();
    }

    public int getRow() {
        return this.getPropertyInteger(new String[]{"parentElement", "index"});
    }

    public GridColumnElement getColumn() {
        Double id = this.getPropertyDouble(new String[]{"_column", "__generatedTbId"});
        GridElement grid = this.getGrid();
        if (id == null) {
            grid.generatedColumnIdsIfNeeded();
            id = this.getPropertyDouble(new String[]{"_column", "__generatedTbId"});
        }
        if (id == null) {
            throw new NoSuchElementException("Unable to find column. This should not really happen.");
        }
        return new GridColumnElement(id.longValue(), grid);
    }

    public GridElement getGrid() {
        return (GridElement)((TestBenchElement)this.executeScript("return arguments[0].getRootNode().host", new Object[]{this})).wrap(GridElement.class);
    }

    public GridTRElement getRowElement() {
        return (GridTRElement)this.getPropertyElement(new String[]{"parentElement"}).wrap(GridTRElement.class);
    }

    public SearchContext getContext() {
        return (SearchContext)this.executeScript("return arguments[0].firstElementChild.assignedNodes()[0];", new Object[]{this});
    }

    WebElement getFirstChildElement() {
        return (WebElement)this.executeScript("return arguments[0].firstElementChild.assignedNodes()[0].firstElementChild;", new Object[]{this});
    }
}

