/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.gridpro;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.grid.ColumnPathRenderer;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.gridpro.EditColumnConfigurator;
import com.vaadin.flow.component.gridpro.EditorType;
import com.vaadin.flow.component.gridpro.ItemUpdater;
import com.vaadin.flow.data.binder.PropertyDefinition;
import com.vaadin.flow.data.provider.CompositeDataGenerator;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.Rendering;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.internal.JsonSerializer;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Tag(value="vaadin-grid-pro")
@NpmPackage(value="@vaadin/vaadin-grid-pro", version="2.0.6")
@JsModule.Container(value={@JsModule(value="@vaadin/vaadin-grid-pro/src/vaadin-grid-pro.js"), @JsModule(value="@vaadin/vaadin-grid-pro/src/vaadin-grid-pro-edit-column.js"), @JsModule(value="./gridProConnector.js")})
public class GridPro<E>
extends Grid<E> {
    private Map<String, Grid.Column<E>> idToColumnMap = new HashMap<String, Grid.Column<E>>();

    public GridPro(Class<E> beanType) {
        super(beanType);
        this.setup();
    }

    public GridPro() {
        this.setup();
    }

    public GridPro(int pageSize) {
        super(pageSize);
        this.setup();
    }

    public void onEnabledStateChanged(boolean enabled) {
        super.onEnabledStateChanged(enabled);
        this.getElement().setProperty("_editingDisabled", !enabled);
    }

    private void setup() {
        this.addItemPropertyChangedListener((ComponentEventListener & Serializable)e -> {
            EditColumn column = (EditColumn)this.idToColumnMap.get(((ItemPropertyChangedEvent)e).getPath());
            if (column.getEditorType().equals("custom")) {
                column.getItemUpdater().accept(e.getItem(), null);
            } else {
                column.getItemUpdater().accept(e.getItem(), ((ItemPropertyChangedEvent)e).getSourceItem().get(((ItemPropertyChangedEvent)e).getPath()).asString());
            }
            this.getDataProvider().refreshItem(e.getItem());
        });
        this.addCellEditStartedListener((ComponentEventListener & Serializable)e -> {
            EditColumn column = (EditColumn)this.idToColumnMap.get(((CellEditStartedEvent)e).getPath());
            if (column.getEditorType().equals("custom")) {
                column.getEditorField().setValue(column.getValueProvider().apply(e.getItem()));
            }
        });
    }

    public EditColumnConfigurator<E> addEditColumn(ValueProvider<E, ?> valueProvider) {
        EditColumn column = (EditColumn)this.addColumn(valueProvider, this::createEditColumn);
        return new EditColumnConfigurator<E>(column, valueProvider);
    }

    public EditColumnConfigurator<E> addEditColumn(ValueProvider<E, ?> valueProvider, Renderer<E> renderer) {
        String columnId = this.createColumnId(false);
        EditColumn column = (EditColumn)this.addColumn((Renderer)new ColumnComponentPathRenderer<E>(columnId, (ValueProvider & Serializable)value -> {
            Object item = valueProvider.apply(value);
            if (item != null) {
                return item.toString();
            }
            return "";
        }, renderer), this::createEditColumn);
        this.idToColumnMap.put(columnId, column);
        return new EditColumnConfigurator<E>(column, valueProvider);
    }

    public <V extends Comparable<? super V>> EditColumnConfigurator<E> addEditColumn(ValueProvider<E, V> valueProvider, String ... sortingProperties) {
        EditColumn column = (EditColumn)this.addColumn(valueProvider, this::createEditColumn);
        column.setComparator(valueProvider);
        column.setSortProperty(sortingProperties);
        return new EditColumnConfigurator<E>(column, valueProvider);
    }

    public EditColumnConfigurator<E> addEditColumn(String propertyName) {
        EditColumn column = (EditColumn)this.addColumn(propertyName, this::createEditColumn);
        ValueProvider & Serializable valueProvider = (ValueProvider & Serializable)item -> ((PropertyDefinition)this.getPropertySet().getProperty(propertyName).get()).getGetter().apply(item);
        return new EditColumnConfigurator(column, valueProvider);
    }

    public void setEnterNextRow(boolean enterNextRow) {
        this.getElement().setProperty("enterNextRow", enterNextRow);
    }

    @Synchronize(value={"enter-next-row-changed"})
    public boolean getEnterNextRow() {
        return this.getElement().getProperty("enterNextRow", false);
    }

    public void setSingleCellEdit(boolean singleCellEdit) {
        this.getElement().setProperty("singleCellEdit", singleCellEdit);
    }

    @Synchronize(value={"single-cell-edit-changed"})
    public boolean getSingleCellEdit() {
        return this.getElement().getProperty("singleCellEdit", false);
    }

    protected EditColumn<E> createEditColumn(Renderer<E> renderer, String columnId) {
        EditColumn<E> column = new EditColumn<E>(this, columnId, renderer);
        this.idToColumnMap.put(columnId, column);
        return column;
    }

    public Registration addCellEditStartedListener(ComponentEventListener<CellEditStartedEvent<E>> listener) {
        return ComponentUtil.addListener((Component)this, CellEditStartedEvent.class, listener);
    }

    public Registration addItemPropertyChangedListener(ComponentEventListener<ItemPropertyChangedEvent<E>> listener) {
        return ComponentUtil.addListener((Component)this, ItemPropertyChangedEvent.class, listener);
    }

    class ColumnComponentPathRenderer<SOURCE>
    extends ColumnPathRenderer<SOURCE> {
        private Renderer<SOURCE> representationRenderer;

        public ColumnComponentPathRenderer(String property, ValueProvider<SOURCE, ?> provider, Renderer<SOURCE> renderer) {
            super(property, provider);
            this.representationRenderer = renderer;
        }

        public Rendering<SOURCE> render(Element container, DataKeyMapper<SOURCE> keyMapper, Element contentTemplate) {
            final Rendering columnPathRendering = super.render(container, keyMapper, contentTemplate);
            final Rendering representationRendering = this.representationRenderer.render(container, keyMapper);
            return new Rendering<SOURCE>(){

                public Optional<DataGenerator<SOURCE>> getDataGenerator() {
                    CompositeDataGenerator compositeDataGenerator = new CompositeDataGenerator();
                    compositeDataGenerator.addDataGenerator((DataGenerator)representationRendering.getDataGenerator().get());
                    compositeDataGenerator.addDataGenerator((DataGenerator)columnPathRendering.getDataGenerator().get());
                    return Optional.of(compositeDataGenerator);
                }

                public Element getTemplateElement() {
                    return representationRendering.getTemplateElement();
                }
            };
        }
    }

    @DomEvent(value="item-property-changed")
    public static class ItemPropertyChangedEvent<E>
    extends ComponentEvent<GridPro<E>> {
        private E item;
        private JsonObject sourceItem;
        private String path;

        public ItemPropertyChangedEvent(GridPro<E> source, boolean fromClient, @EventData(value="event.detail.item") JsonObject item, @EventData(value="event.detail.path") String path) {
            super(source, fromClient);
            this.sourceItem = item;
            this.item = source.getDataCommunicator().getKeyMapper().get(item.getString("key"));
            this.path = path;
        }

        public E getItem() {
            return this.item;
        }

        private JsonObject getSourceItem() {
            return this.sourceItem;
        }

        private String getPath() {
            return this.path;
        }
    }

    @DomEvent(value="cell-edit-started")
    public static class CellEditStartedEvent<E>
    extends ComponentEvent<GridPro<E>> {
        private E item;
        private String path;

        public CellEditStartedEvent(GridPro<E> source, boolean fromClient, @EventData(value="event.detail.item") JsonObject item, @EventData(value="event.detail.path") String path) {
            super(source, fromClient);
            this.item = source.getDataCommunicator().getKeyMapper().get(item.getString("key"));
            this.path = path;
        }

        public E getItem() {
            return this.item;
        }

        private String getPath() {
            return this.path;
        }
    }

    @Tag(value="vaadin-grid-pro-edit-column")
    public static class EditColumn<T>
    extends Grid.Column<T> {
        private ItemUpdater<T, String> itemUpdater;
        private AbstractField editorField;
        private ValueProvider<T, ?> valueProvider;

        public EditColumn(GridPro<T> grid, String columnId, Renderer<T> renderer) {
            super(grid, columnId, renderer);
        }

        protected EditColumn<T> setItemUpdater(ItemUpdater<T, String> itemUpdater) {
            this.itemUpdater = itemUpdater;
            return this;
        }

        protected ItemUpdater<T, String> getItemUpdater() {
            return this.itemUpdater;
        }

        protected AbstractField getEditorField() {
            return this.editorField;
        }

        protected void setEditorField(AbstractField editorField) {
            this.editorField = editorField;
        }

        protected EditColumn<T> setEditorType(EditorType type) {
            this.getElement().setProperty("editorType", type == null ? "text" : type.getTypeName());
            return this;
        }

        @Synchronize(value={"editor-type-changed"})
        protected String getEditorType() {
            return this.getElement().getProperty("editorType", "text");
        }

        protected EditColumn<T> setOptions(List<String> options) {
            this.getElement().setPropertyJson("editorOptions", (JsonValue)JsonSerializer.toJson(options));
            return this;
        }

        @Synchronize(value={"editor-options-changed"})
        protected List<String> getOptions() {
            return JsonSerializer.toObjects(String.class, (JsonArray)((JsonArray)this.getElement().getPropertyRaw("editorOptions")));
        }

        public ValueProvider<T, ?> getValueProvider() {
            return this.valueProvider;
        }

        public void setValueProvider(ValueProvider<T, ?> valueProvider) {
            this.valueProvider = valueProvider;
        }
    }
}

