/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid;

import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.grid.Grid;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import tools.jackson.databind.node.ArrayNode;

@DomEvent(value="column-reorder-all-columns")
public class ColumnReorderEvent<T>
extends ComponentEvent<Grid<T>> {
    private final List<Grid.Column<T>> columns;

    public ColumnReorderEvent(Grid<T> source, boolean fromClient, @EventData(value="event.detail.columns") ArrayNode columnIDs) {
        this(source, fromClient, ColumnReorderEvent.getSortedByIds(source.getColumns(), columnIDs));
    }

    public ColumnReorderEvent(Grid<T> source, boolean fromClient, List<Grid.Column<T>> columns) {
        super(source, fromClient);
        this.columns = Collections.unmodifiableList(new ArrayList<Grid.Column<T>>(columns));
    }

    public List<Grid.Column<T>> getColumns() {
        return this.columns;
    }

    private static <T> List<Grid.Column<T>> getSortedByIds(List<Grid.Column<T>> currentColumns, ArrayNode columnIDs) {
        ArrayList<Grid.Column<T>> columns = new ArrayList<Grid.Column<T>>(currentColumns.size());
        for (int i = 0; i < columnIDs.size(); ++i) {
            String columnID = columnIDs.get(i).asString();
            columns.add(ColumnReorderEvent.findByColumnId(currentColumns, columnID));
        }
        return columns;
    }

    private static <T> Grid.Column<T> findByColumnId(List<Grid.Column<T>> columns, String id) {
        return columns.stream().filter(it -> id.equals(it.getInternalId())).findFirst().orElseThrow(() -> new IllegalArgumentException("No column with ID " + id));
    }
}

