/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.grid.AbstractColumn;
import com.vaadin.flow.component.grid.AbstractRow;
import com.vaadin.flow.component.grid.ColumnLayer;
import java.util.Collection;
import java.util.List;

public class FooterRow
extends AbstractRow<FooterCell> {
    FooterRow(ColumnLayer layer) {
        super(layer, FooterCell::new);
    }

    @Override
    public FooterCell join(Collection<FooterCell> cells) {
        if (this.layer.getGrid().getColumnLayers().indexOf(this.layer) == 0) {
            throw new UnsupportedOperationException("Cells cannot be joined on the top-most footer row. This row is used as the default row for setting column footers, so each cell in it should have maximum one related column.");
        }
        return super.join(cells);
    }

    @Override
    protected boolean isOutmostRow() {
        List<ColumnLayer> layers = this.layer.getGrid().getColumnLayers();
        for (int i = layers.size() - 1; i >= 0; --i) {
            ColumnLayer layer = layers.get(i);
            if (!layer.isFooterRow()) continue;
            return this.equals(layer.asFooterRow());
        }
        return false;
    }

    public static class FooterCell
    extends AbstractRow.AbstractCell {
        FooterCell(AbstractColumn<?> column) {
            super(column);
            if (column.getFooterRenderer() == null) {
                column.setFooterText("");
            }
        }

        @Override
        public String getText() {
            return this.getColumn().getFooterText();
        }

        @Override
        public void setText(String text) {
            this.getColumn().setFooterText(text);
        }

        @Override
        public Component getComponent() {
            return this.getColumn().getFooterComponent();
        }

        @Override
        public void setComponent(Component component) {
            this.getColumn().setFooterComponent(component);
        }
    }
}

