/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridMultiSelectionModel;
import com.vaadin.flow.component.grid.GridSelectionColumn;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalQuery;
import com.vaadin.flow.data.selection.MultiSelect;
import com.vaadin.flow.data.selection.MultiSelectionEvent;
import com.vaadin.flow.data.selection.MultiSelectionListener;
import com.vaadin.flow.data.selection.SelectionEvent;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractGridMultiSelectionModel<T>
extends Grid.AbstractGridExtension<T>
implements GridMultiSelectionModel<T> {
    private final Set<T> selected = new LinkedHashSet<T>();
    private final GridSelectionColumn selectionColumn = new GridSelectionColumn(this::clientSelectAll, this::clientDeselectAll);
    private GridMultiSelectionModel.SelectAllCheckboxVisibility selectAllCheckBoxVisibility = GridMultiSelectionModel.SelectAllCheckboxVisibility.DEFAULT;

    public AbstractGridMultiSelectionModel(Grid<T> grid) {
        super(grid);
        this.selectionColumn.setSelectAllCheckBoxVisibility(this.isSelectAllCheckboxVisible());
        if (grid.getElement().getNode().isAttached()) {
            this.insertSelectionColumn(grid, this.selectionColumn);
        } else {
            grid.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> {
                if (grid.getSelectionModel() == this) {
                    this.insertSelectionColumn(grid, this.selectionColumn);
                }
            });
        }
    }

    private void insertSelectionColumn(Grid<T> grid, GridSelectionColumn selectionColumn) {
        grid.getElement().insertChild(0, new Element[]{selectionColumn.getElement()});
    }

    @Override
    protected void remove() {
        super.remove();
        this.deselectAll();
        if (this.selectionColumn.getElement().getNode().isAttached()) {
            this.getGrid().getElement().removeChild(new Element[]{this.selectionColumn.getElement()});
        }
    }

    @Override
    public void selectFromClient(T item) {
        if (this.isSelected(item)) {
            return;
        }
        LinkedHashSet<T> oldSelection = new LinkedHashSet<T>(this.selected);
        boolean added = this.selected.add(item);
        if (added) {
            this.fireSelectionEvent((SelectionEvent<Grid<T>, T>)new MultiSelectionEvent(this.getGrid(), this.getGrid().asMultiSelect(), oldSelection, true));
            if (!this.isSelectAllCheckboxVisible()) {
                return;
            }
            long size = this.getDataProviderSize();
            this.selectionColumn.setSelectAllCheckboxState(!this.isHierarchicalDataProvider() && size == (long)this.selected.size());
            this.selectionColumn.setSelectAllCheckboxIndeterminateState(this.isHierarchicalDataProvider() ? this.selected.size() > 0 : this.selected.size() > 0 && (long)this.selected.size() < size);
        }
    }

    @Override
    public void deselectFromClient(T item) {
        if (!this.isSelected(item)) {
            return;
        }
        LinkedHashSet<T> oldSelection = new LinkedHashSet<T>(this.selected);
        boolean removed = this.selected.remove(item);
        if (removed) {
            this.fireSelectionEvent((SelectionEvent<Grid<T>, T>)new MultiSelectionEvent(this.getGrid(), this.getGrid().asMultiSelect(), oldSelection, true));
            long size = this.getDataProviderSize();
            this.selectionColumn.setSelectAllCheckboxState(false);
            this.selectionColumn.setSelectAllCheckboxIndeterminateState(this.isHierarchicalDataProvider() ? this.selected.size() > 0 : this.selected.size() > 0 && (long)this.selected.size() < size);
        }
    }

    public Set<T> getSelectedItems() {
        return Collections.unmodifiableSet(new LinkedHashSet<T>(this.selected));
    }

    public Optional<T> getFirstSelectedItem() {
        return this.selected.stream().findFirst();
    }

    public void select(T item) {
        if (this.isSelected(item)) {
            return;
        }
        HashSet<T> selected = new HashSet<T>();
        if (item != null) {
            selected.add(item);
        }
        this.doUpdateSelection(selected, Collections.emptySet(), false);
    }

    public void deselect(T item) {
        if (!this.isSelected(item)) {
            return;
        }
        HashSet<T> deselected = new HashSet<T>();
        if (item != null) {
            deselected.add(item);
        }
        this.doUpdateSelection(Collections.emptySet(), deselected, false);
        this.selectionColumn.setSelectAllCheckboxState(false);
    }

    public void selectAll() {
        this.updateSelection(this.getGrid().getDataCommunicator().getDataProvider().fetch(new Query()).collect(Collectors.toSet()), Collections.emptySet());
        this.selectionColumn.setSelectAllCheckboxState(true);
        this.selectionColumn.setSelectAllCheckboxIndeterminateState(false);
    }

    public void deselectAll() {
        this.updateSelection(Collections.emptySet(), this.getSelectedItems());
        this.selectionColumn.setSelectAllCheckboxState(false);
        this.selectionColumn.setSelectAllCheckboxIndeterminateState(false);
    }

    public void updateSelection(Set<T> addedItems, Set<T> removedItems) {
        Objects.requireNonNull(addedItems, "added items cannot be null");
        Objects.requireNonNull(removedItems, "removed items cannot be null");
        this.doUpdateSelection(addedItems, removedItems, false);
    }

    public boolean isSelected(T item) {
        return this.getSelectedItems().stream().anyMatch(selectedItem -> Objects.equals(this.getItemId(selectedItem), this.getItemId(item)));
    }

    @Override
    public MultiSelect<Grid<T>, T> asMultiSelect() {
        return new MultiSelect<Grid<T>, T>(){

            public Registration addValueChangeListener(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<Grid<T>, Set<T>>> listener) {
                Objects.requireNonNull(listener, "listener cannot be null");
                ComponentEventListener & Serializable componentEventListener = (ComponentEventListener & Serializable)event -> listener.valueChanged((HasValue.ValueChangeEvent)((AbstractField.ComponentValueChangeEvent)event));
                return ComponentUtil.addListener(AbstractGridMultiSelectionModel.this.getGrid(), MultiSelectionEvent.class, (ComponentEventListener)componentEventListener);
            }

            public Registration addSelectionListener(MultiSelectionListener<Grid<T>, T> listener) {
                return AbstractGridMultiSelectionModel.this.addMultiSelectionListener(listener);
            }

            public void deselectAll() {
                AbstractGridMultiSelectionModel.this.deselectAll();
            }

            public void updateSelection(Set<T> addedItems, Set<T> removedItems) {
                AbstractGridMultiSelectionModel.this.updateSelection(addedItems, removedItems);
            }

            public Element getElement() {
                return AbstractGridMultiSelectionModel.this.getGrid().getElement();
            }

            public Set<T> getSelectedItems() {
                return AbstractGridMultiSelectionModel.this.getSelectedItems();
            }
        };
    }

    public Registration addSelectionListener(SelectionListener<Grid<T>, T> listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        return ComponentUtil.addListener(this.getGrid(), MultiSelectionEvent.class, (ComponentEventListener & Serializable)event -> listener.selectionChange((SelectionEvent)event));
    }

    @Override
    public Registration addMultiSelectionListener(MultiSelectionListener<Grid<T>, T> listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        return ComponentUtil.addListener(this.getGrid(), MultiSelectionEvent.class, (ComponentEventListener & Serializable)event -> listener.selectionChange((MultiSelectionEvent)event));
    }

    @Override
    public void setSelectAllCheckboxVisibility(GridMultiSelectionModel.SelectAllCheckboxVisibility selectAllCheckBoxVisibility) {
        this.selectAllCheckBoxVisibility = selectAllCheckBoxVisibility;
        this.selectionColumn.setSelectAllCheckBoxVisibility(this.isSelectAllCheckboxVisible());
    }

    @Override
    public GridMultiSelectionModel.SelectAllCheckboxVisibility getSelectAllCheckboxVisibility() {
        return this.selectAllCheckBoxVisibility;
    }

    @Override
    public boolean isSelectAllCheckboxVisible() {
        switch (this.selectAllCheckBoxVisibility) {
            case DEFAULT: {
                return this.getGrid().getDataCommunicator().getDataProvider().isInMemory();
            }
            case HIDDEN: {
                return false;
            }
            case VISIBLE: {
                return this.getGrid().getDataCommunicator().isDefinedSize();
            }
        }
        throw new IllegalStateException(String.format("Select all checkbox visibility is set to an unsupported value: %s", new Object[]{this.selectAllCheckBoxVisibility}));
    }

    public void generateData(T item, JsonObject jsonObject) {
        if (this.isSelected(item)) {
            jsonObject.put("selected", true);
        }
    }

    @Override
    public void setSelectionColumnFrozen(boolean frozen) {
        this.selectionColumn.setFrozen(frozen);
    }

    @Override
    public boolean isSelectionColumnFrozen() {
        return this.selectionColumn.isFrozen();
    }

    protected abstract void fireSelectionEvent(SelectionEvent<Grid<T>, T> var1);

    void clientSelectAll() {
        if (!this.isSelectAllCheckboxVisible()) {
            return;
        }
        DataProvider dataProvider = this.getGrid().getDataCommunicator().getDataProvider();
        Stream allItemsStream = dataProvider instanceof HierarchicalDataProvider ? this.fetchAllHierarchical((HierarchicalDataProvider)dataProvider) : dataProvider.fetch(new Query());
        this.doUpdateSelection(allItemsStream.collect(Collectors.toSet()), Collections.emptySet(), true);
        this.selectionColumn.setSelectAllCheckboxState(true);
        this.selectionColumn.setSelectAllCheckboxIndeterminateState(false);
    }

    private Stream<T> fetchAllHierarchical(HierarchicalDataProvider<T, ?> dataProvider) {
        return this.fetchAllDescendants(null, dataProvider);
    }

    private Stream<T> fetchAllDescendants(T parent, HierarchicalDataProvider<T, ?> dataProvider) {
        if (parent != null && !dataProvider.hasChildren(parent)) {
            return Stream.empty();
        }
        List children = dataProvider.fetchChildren(new HierarchicalQuery(null, parent)).collect(Collectors.toList());
        if (children.isEmpty()) {
            return Stream.empty();
        }
        return children.stream().flatMap(child -> Stream.concat(Stream.of(child), this.fetchAllDescendants(child, dataProvider)));
    }

    void clientDeselectAll() {
        if (!this.isSelectAllCheckboxVisible()) {
            return;
        }
        this.doUpdateSelection(Collections.emptySet(), this.getSelectedItems(), true);
        this.selectionColumn.setSelectAllCheckboxState(false);
        this.selectionColumn.setSelectAllCheckboxIndeterminateState(false);
    }

    private void doUpdateSelection(Set<T> addedItems, Set<T> removedItems, boolean userOriginated) {
        Map addedItemsMap = this.mapItemsById(addedItems);
        Map removedItemsMap = this.mapItemsById(removedItems);
        addedItemsMap.keySet().stream().filter(removedItemsMap::containsKey).collect(Collectors.toList()).forEach(key -> {
            addedItemsMap.remove(key);
            removedItemsMap.remove(key);
        });
        this.doUpdateSelection(addedItemsMap, removedItemsMap, userOriginated);
    }

    private void doUpdateSelection(Map<Object, T> addedItems, Map<Object, T> removedItems, boolean userOriginated) {
        Map<Object, T> selectedMap = this.mapItemsById(this.selected);
        if (selectedMap.keySet().containsAll(addedItems.keySet()) && Collections.disjoint(selectedMap.keySet(), removedItems.keySet())) {
            return;
        }
        LinkedHashSet<T> oldSelection = new LinkedHashSet<T>(this.selected);
        removedItems.keySet().forEach(selectedMap::remove);
        selectedMap.putAll(addedItems);
        this.selected.clear();
        this.selected.addAll(selectedMap.values());
        this.sendSelectionUpdate(new LinkedHashSet<T>(addedItems.values()), this.getGrid()::doClientSideSelection);
        this.sendSelectionUpdate(new LinkedHashSet<T>(removedItems.values()), this.getGrid()::doClientSideDeselection);
        this.fireSelectionEvent((SelectionEvent<Grid<T>, T>)new MultiSelectionEvent(this.getGrid(), this.getGrid().asMultiSelect(), oldSelection, userOriginated));
        long size = this.getDataProviderSize();
        this.selectionColumn.setSelectAllCheckboxState(!this.isHierarchicalDataProvider() && size == (long)this.selected.size());
        this.selectionColumn.setSelectAllCheckboxIndeterminateState(this.isHierarchicalDataProvider() ? this.selected.size() > 0 : this.selected.size() > 0 && (long)this.selected.size() < size);
    }

    private Map<Object, T> mapItemsById(Set<T> items) {
        return items.stream().collect(LinkedHashMap::new, (map, item) -> map.put(this.getItemId(item), item), Map::putAll);
    }

    private void sendSelectionUpdate(Set<T> updatedItems, Consumer<Set<T>> clientSideUpdater) {
        Set<Object> activeItems = updatedItems.stream().filter(this.getGrid()::isInActiveRange).collect(Collectors.toSet());
        if (activeItems.isEmpty()) {
            return;
        }
        activeItems.forEach(arg_0 -> this.getGrid().getDataCommunicator().refresh(arg_0));
        clientSideUpdater.accept(activeItems);
    }

    private Object getItemId(T item) {
        return this.getGrid().getDataCommunicator().getDataProvider().getId(item);
    }

    private long getDataProviderSize() {
        long size = 0L;
        DataCommunicator dataCommunicator = this.getGrid().getDataCommunicator();
        DataProvider dataProvider = dataCommunicator.getDataProvider();
        if (!(dataProvider instanceof HierarchicalDataProvider)) {
            if (dataProvider.isInMemory()) {
                size = dataProvider.size(new Query());
            } else if (dataCommunicator.isDefinedSize()) {
                size = dataCommunicator.getItemCount();
            }
        }
        return size;
    }

    private boolean isHierarchicalDataProvider() {
        return this.getGrid().getDataCommunicator().getDataProvider() instanceof HierarchicalDataProvider;
    }
}

