/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.treegrid;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.data.renderer.ComponentDataGenerator;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Rendering;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.internal.JsonSerializer;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.Optional;

public class HierarchyColumnComponentRenderer<COMPONENT extends Component, SOURCE>
extends ComponentRenderer<COMPONENT, SOURCE> {
    public HierarchyColumnComponentRenderer(ValueProvider<SOURCE, COMPONENT> componentProvider) {
        super(componentProvider);
    }

    public HierarchyColumnComponentRenderer<COMPONENT, SOURCE> withProperty(String property, ValueProvider<SOURCE, ?> provider) {
        this.setProperty(property, provider);
        return this;
    }

    public Rendering<SOURCE> render(Element container, DataKeyMapper<SOURCE> keyMapper, Element contentTemplate) {
        ComponentRendering rendering = new ComponentRendering(keyMapper == null ? null : arg_0 -> keyMapper.key(arg_0));
        rendering.setTemplateElement(contentTemplate);
        container.getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> this.setupTemplateWhenAttached((UI)ui, container, rendering, keyMapper));
        return rendering;
    }

    private void setupTemplateWhenAttached(UI ui, Element owner, ComponentRendering rendering, DataKeyMapper<SOURCE> keyMapper) {
        String templateInnerHtml;
        String appId = ui.getInternals().getAppId();
        Element templateElement = rendering.getTemplateElement();
        owner.appendChild(new Element[]{templateElement});
        Element container = new Element("div");
        owner.appendVirtualChild(new Element[]{container});
        rendering.setContainer(container);
        if (keyMapper != null) {
            String nodeIdPropertyName = "_renderer_" + templateElement.getNode().getId();
            templateInnerHtml = String.format("<flow-component-renderer appid=\"%s\" nodeid=\"[[item.%s]]\"></flow-component-renderer>", appId, nodeIdPropertyName);
            rendering.setNodeIdPropertyName(nodeIdPropertyName);
        } else {
            Component component = this.createComponent(null);
            if (component != null) {
                container.appendChild(new Element[]{component.getElement()});
                templateInnerHtml = String.format("<flow-component-renderer appid=\"%s\" nodeid=\"%s\"></flow-component-renderer>", appId, component.getElement().getNode().getId());
            } else {
                templateInnerHtml = "";
            }
        }
        templateInnerHtml = "<vaadin-grid-tree-toggle class$='[[item.cssClassName]]' leaf='[[item.leaf]]' expanded='{{expanded}}' level='[[level]]'>" + templateInnerHtml + "</vaadin-grid-tree-toggle>";
        templateElement.setProperty("innerHTML", templateInnerHtml);
    }

    private class ComponentRendering
    extends ComponentDataGenerator<SOURCE>
    implements Rendering<SOURCE> {
        private Element templateElement;

        public ComponentRendering(ValueProvider<SOURCE, String> keyMapper) {
            super((ComponentRenderer)HierarchyColumnComponentRenderer.this, keyMapper);
        }

        public void setTemplateElement(Element templateElement) {
            this.templateElement = templateElement;
        }

        public Element getTemplateElement() {
            return this.templateElement;
        }

        public Optional<DataGenerator<SOURCE>> getDataGenerator() {
            return Optional.of(this);
        }

        public void generateData(SOURCE item, JsonObject jsonObject) {
            super.generateData(item, jsonObject);
            HierarchyColumnComponentRenderer.this.getValueProviders().forEach((key, provider) -> jsonObject.put(key, JsonSerializer.toJson((Object)provider.apply(item))));
        }
    }
}

