/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid.editor;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.grid.editor.Editor;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.Rendering;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.ExecutionContext;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.Optional;

public class EditorRenderer<T>
extends Renderer<T>
implements DataGenerator<T> {
    private final Editor<T> editor;
    private final String columnInternalId;
    private Element editorContainer;
    private SerializableFunction<T, ? extends Component> componentFunction;
    private Component component;
    private Component emptyComponent;

    public EditorRenderer(Editor<T> editor, String columnInternalId) {
        this.editor = editor;
        this.columnInternalId = columnInternalId;
    }

    public void setComponentFunction(SerializableFunction<T, ? extends Component> componentFunction) {
        this.componentFunction = componentFunction;
    }

    public void generateData(T item, JsonObject jsonObject) {
        if (this.editor.isOpen() && this.component != null) {
            int nodeId = this.getComponentNodeId(this.component);
            jsonObject.put("_" + this.columnInternalId + "_editor", (double)nodeId);
        }
    }

    private void buildComponent(T item) {
        if (this.componentFunction != null) {
            this.setComponent((Component)this.componentFunction.apply(item));
        } else {
            this.setComponent(null);
        }
    }

    private void setComponent(Component newComponent) {
        if (this.component != null) {
            if (this.component.equals(newComponent)) {
                return;
            }
            if (this.component.getElement().getParent().equals((Object)this.editorContainer)) {
                this.editorContainer.removeChild(new Element[]{this.component.getElement()});
            }
        }
        if (newComponent == null) {
            newComponent = this.getOrCreateEmptyComponent();
        }
        this.editorContainer.appendChild(new Element[]{newComponent.getElement()});
        this.component = newComponent;
    }

    private Component getOrCreateEmptyComponent() {
        if (this.emptyComponent == null) {
            this.emptyComponent = new Span();
        }
        return this.emptyComponent;
    }

    public void refreshData(T item) {
        if (this.editor.isOpen()) {
            this.buildComponent(item);
        }
    }

    public Rendering<T> render(Element container, DataKeyMapper<T> keyMapper, Element contentTemplate) {
        this.editorContainer = this.createEditorContainer();
        container.appendVirtualChild(new Element[]{this.editorContainer});
        this.runBeforeClientResponse(container, (SerializableConsumer<ExecutionContext>)(SerializableConsumer & Serializable)context -> {
            String originalTemplate = contentTemplate.getProperty("innerHTML");
            String appId = context.getUI().getInternals().getAppId();
            String editorTemplate = String.format("<flow-component-renderer appid='%s' nodeid='[[item._%s_editor]]'></flow-component-renderer>", appId, this.columnInternalId);
            contentTemplate.setProperty("innerHTML", String.format("<template is='dom-if' if='[[item._editing]]' restamp>%s</template><template is='dom-if' if='[[!item._editing]]' restamp>%s</template>", editorTemplate, originalTemplate));
        });
        return new EditorRendering(contentTemplate);
    }

    private void runBeforeClientResponse(Element container, SerializableConsumer<ExecutionContext> execution) {
        container.getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.getInternals().getStateTree().beforeClientResponse(container.getNode(), execution));
    }

    int getComponentNodeId(Component component) {
        return component.getElement().getNode().getId();
    }

    Element createEditorContainer() {
        return ElementFactory.createDiv();
    }

    private class EditorRendering
    implements Rendering<T> {
        private final Element contentTemplate;

        public EditorRendering(Element contentTemplate) {
            this.contentTemplate = contentTemplate;
        }

        public Optional<DataGenerator<T>> getDataGenerator() {
            return Optional.of(EditorRenderer.this);
        }

        public Element getTemplateElement() {
            return this.contentTemplate;
        }
    }
}

