/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid.dnd;

import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.grid.Grid;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;

@DomEvent(value="grid-dragstart")
public class GridDragStartEvent<T>
extends ComponentEvent<Grid<T>> {
    private final List<T> draggedItems;

    public GridDragStartEvent(Grid<T> source, boolean fromClient, @EventData(value="event.detail") JsonObject details) {
        super(source, fromClient);
        JsonArray items = details.getArray("draggedItems");
        this.draggedItems = new ArrayList<T>();
        IntStream.range(0, items.length()).forEach(i -> {
            String itemKey = items.getObject(i).getString("key");
            Object item = source.getDataCommunicator().getKeyMapper().get(itemKey);
            this.draggedItems.add(item);
        });
    }

    public List<T> getDraggedItems() {
        return Collections.unmodifiableList(this.draggedItems);
    }
}

