/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid;

import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.grid.AbstractColumn;
import com.vaadin.flow.component.grid.AbstractGridMultiSelectionModel;
import com.vaadin.flow.component.grid.AbstractGridSingleSelectionModel;
import com.vaadin.flow.component.grid.ColumnBase;
import com.vaadin.flow.component.grid.ColumnGroup;
import com.vaadin.flow.component.grid.ColumnGroupHelpers;
import com.vaadin.flow.component.grid.ColumnLayer;
import com.vaadin.flow.component.grid.FooterRow;
import com.vaadin.flow.component.grid.GridMultiSelectionModel;
import com.vaadin.flow.component.grid.GridNoneSelectionModel;
import com.vaadin.flow.component.grid.GridSelectionModel;
import com.vaadin.flow.component.grid.GridSingleSelectionModel;
import com.vaadin.flow.component.grid.GridSortOrder;
import com.vaadin.flow.component.grid.GridSortOrderBuilder;
import com.vaadin.flow.component.grid.HeaderRow;
import com.vaadin.flow.component.grid.SortOrderProvider;
import com.vaadin.flow.data.binder.BeanPropertySet;
import com.vaadin.flow.data.binder.HasDataProvider;
import com.vaadin.flow.data.binder.PropertyDefinition;
import com.vaadin.flow.data.binder.PropertySet;
import com.vaadin.flow.data.event.SortEvent;
import com.vaadin.flow.data.provider.ArrayUpdater;
import com.vaadin.flow.data.provider.CompositeDataGenerator;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.KeyMapper;
import com.vaadin.flow.data.provider.QuerySortOrder;
import com.vaadin.flow.data.provider.SortDirection;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.Rendering;
import com.vaadin.flow.data.renderer.TemplateRenderer;
import com.vaadin.flow.data.selection.MultiSelect;
import com.vaadin.flow.data.selection.SelectionEvent;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.data.selection.SingleSelect;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableComparator;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.shared.Registration;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

@Tag(value="vaadin-grid")
@HtmlImport.Container(value={@HtmlImport(value="frontend://bower_components/vaadin-grid/src/vaadin-grid.html"), @HtmlImport(value="frontend://bower_components/vaadin-grid/src/vaadin-grid-column.html"), @HtmlImport(value="frontend://bower_components/vaadin-grid/src/vaadin-grid-sorter.html"), @HtmlImport(value="frontend://bower_components/vaadin-checkbox/src/vaadin-checkbox.html"), @HtmlImport(value="frontend://flow-component-renderer.html")})
@JavaScript(value="frontend://gridConnector.js")
public class Grid<T>
extends Component
implements HasDataProvider<T>,
HasStyle,
HasSize,
Focusable<Grid<T>>,
SortEvent.SortNotifier<Grid<T>, GridSortOrder<T>> {
    private final ArrayUpdater arrayUpdater = new ArrayUpdater(){

        public ArrayUpdater.Update startUpdate(int sizeChange) {
            return new UpdateQueue(sizeChange);
        }

        public void initialize() {
            Grid.this.initConnector();
            Grid.this.updateSelectionModeOnClient();
        }
    };
    private final CompositeDataGenerator<T> gridDataGenerator = new CompositeDataGenerator();
    private final DataCommunicator<T> dataCommunicator = new DataCommunicator(this.gridDataGenerator, this.arrayUpdater, (SerializableConsumer & Serializable)data -> this.getElement().callFunction("$connector.updateData", new Serializable[]{data}), this.getElement().getNode());
    private int nextColumnId = 0;
    private GridSelectionModel<T> selectionModel;
    private SelectionMode selectionMode;
    private final DetailsManager detailsManager = new DetailsManager(this);
    private Element detailsTemplate;
    private boolean detailsVisibleOnClick = true;
    private Map<String, Column<T>> idToColumnMap = new HashMap<String, Column<T>>();
    private Map<String, Column<T>> keyToColumnMap = new HashMap<String, Column<T>>();
    private final List<GridSortOrder<T>> sortOrder = new ArrayList<GridSortOrder<T>>();
    private PropertySet<T> propertySet;
    private DataGenerator<T> itemDetailsDataGenerator;
    private List<ColumnLayer> columnLayers = new ArrayList<ColumnLayer>();
    private HeaderRow defaultHeaderRow;

    public Grid() {
        this(50);
    }

    public Grid(int pageSize) {
        this.setPageSize(pageSize);
        this.setSelectionModel(SelectionMode.SINGLE.createModel(this), SelectionMode.SINGLE);
        this.columnLayers.add(new ColumnLayer(this));
    }

    private void initConnector() {
        ((UI)this.getUI().orElseThrow(() -> new IllegalStateException("Connector can only be initialized for an attached Grid"))).getPage().executeJavaScript("window.Vaadin.Flow.gridConnector.initLazy($0)", new Serializable[]{this.getElement()});
    }

    public Grid(Class<T> beanType) {
        this();
        Objects.requireNonNull(beanType, "Bean type can't be null");
        this.propertySet = BeanPropertySet.get(beanType);
        this.propertySet.getProperties().filter(property -> !property.isSubProperty()).sorted((prop1, prop2) -> prop1.getName().compareTo(prop2.getName())).forEach(this::addColumn);
    }

    public Column<T> addColumn(ValueProvider<T, ?> valueProvider) {
        String columnId = this.createColumnId(false);
        Column<T> column = this.addColumn((Renderer<T>)TemplateRenderer.of((String)("[[item." + columnId + "]]")).withProperty(columnId, (ValueProvider & Serializable)value -> String.valueOf(valueProvider.apply(value))));
        ((Column)column).comparator = (SerializableComparator & Serializable)(a, b) -> Grid.compareMaybeComparables(valueProvider.apply(a), valueProvider.apply(b));
        return column;
    }

    public <V extends Component> Column<T> addComponentColumn(ValueProvider<T, V> componentProvider) {
        return this.addColumn((Renderer<T>)new ComponentRenderer(componentProvider));
    }

    public <V extends Comparable<? super V>> Column<T> addColumn(ValueProvider<T, V> valueProvider, String ... sortingProperties) {
        Column<T> column = this.addColumn(valueProvider);
        column.setComparator(valueProvider);
        column.setSortProperty(sortingProperties);
        return column;
    }

    public Column<T> addColumn(Renderer<T> renderer) {
        String columnId = this.createColumnId(true);
        this.getDataCommunicator().reset();
        Column<T> column = new Column<T>(this, columnId, renderer);
        this.idToColumnMap.put(columnId, column);
        AbstractColumn current = column;
        this.columnLayers.get(0).addColumn(column);
        for (int i = 1; i < this.columnLayers.size(); ++i) {
            ColumnGroup group = new ColumnGroup(this, current);
            this.columnLayers.get(i).addColumn(group);
            current = group;
        }
        this.getElement().appendChild(new Element[]{current.getElement()});
        return column;
    }

    public Column<T> addColumn(Renderer<T> renderer, String ... sortingProperties) {
        Column column = this.addColumn(renderer);
        Map valueProviders = renderer.getValueProviders();
        Set valueProvidersKeySet = valueProviders.keySet();
        List<String> matchingSortingProperties = Arrays.stream(sortingProperties).filter(valueProvidersKeySet::contains).collect(Collectors.toList());
        column.setSortProperty(matchingSortingProperties.toArray(new String[matchingSortingProperties.size()]));
        Comparator combinedComparator = (a, b) -> 0;
        Comparator nullsLastComparator = Comparator.nullsLast(Comparator.naturalOrder());
        for (String sortProperty : matchingSortingProperties) {
            ValueProvider provider = (ValueProvider)valueProviders.get(sortProperty);
            combinedComparator = combinedComparator.thenComparing((a, b) -> {
                Object aa = provider.apply(a);
                if (!(aa instanceof Comparable)) {
                    return 0;
                }
                Object bb = provider.apply(b);
                return nullsLastComparator.compare(aa, bb);
            });
        }
        column.setComparator(combinedComparator);
        return column;
    }

    public Column<T> addColumn(String propertyName) {
        PropertyDefinition property;
        if (this.propertySet == null) {
            throw new UnsupportedOperationException("This method can't be used for a Grid that isn't constructed from a bean type");
        }
        Objects.requireNonNull(propertyName, "Property name can't be null");
        try {
            property = (PropertyDefinition)this.propertySet.getProperty(propertyName).get();
        }
        catch (IllegalArgumentException | NoSuchElementException exception) {
            throw new IllegalArgumentException("Can't resolve property name '" + propertyName + "' from '" + this.propertySet + "'");
        }
        return this.addColumn(property);
    }

    private Column<T> addColumn(PropertyDefinition<T, ?> property) {
        Column<T> column = this.addColumn((ValueProvider & Serializable)item -> this.formatPropertyValue(property, item)).setHeader(property.getCaption());
        try {
            return column.setKey(property.getName());
        }
        catch (IllegalArgumentException exception) {
            throw new IllegalArgumentException("Multiple columns for the same property: " + property.getName());
        }
    }

    private Object formatPropertyValue(PropertyDefinition<T, ?> property, T item) {
        Object value = property.getGetter().apply(item);
        if (value == null) {
            return "";
        }
        return String.valueOf(value);
    }

    public void setColumns(String ... propertyNames) {
        if (this.propertySet == null) {
            throw new UnsupportedOperationException("This method can't be used for a Grid that isn't constructed from a bean type");
        }
        this.getColumns().forEach(this::removeColumn);
        Stream.of(propertyNames).forEach(this::addColumn);
    }

    protected void setColumnKey(String key, Column column) {
        if (this.keyToColumnMap.containsKey(key)) {
            throw new IllegalArgumentException("Duplicate key for columns: " + key);
        }
        this.keyToColumnMap.put(key, column);
    }

    private String createColumnId(boolean increment) {
        int id = this.nextColumnId++;
        if (increment) {
            // empty if block
        }
        return "col" + id;
    }

    public HeaderRow prependHeaderRow() {
        if (this.getHeaderRows().size() == 0) {
            return this.addFirstHeaderRow();
        }
        return this.insertColumnLayer(this.getLastHeaderLayerIndex() + 1).asHeaderRow();
    }

    public HeaderRow appendHeaderRow() {
        if (this.getHeaderRows().size() == 0) {
            return this.addFirstHeaderRow();
        }
        return this.insertInmostColumnLayer(true, false).asHeaderRow();
    }

    protected HeaderRow addFirstHeaderRow() {
        this.defaultHeaderRow = this.columnLayers.get(0).asHeaderRow();
        this.columnLayers.get(0).updateSortingIndicators(true);
        return this.defaultHeaderRow;
    }

    protected HeaderRow getDefaultHeaderRow() {
        return this.defaultHeaderRow;
    }

    public FooterRow prependFooterRow() {
        if (this.getFooterRows().size() == 0) {
            return this.columnLayers.get(0).asFooterRow();
        }
        return this.insertInmostColumnLayer(false, true).asFooterRow();
    }

    public FooterRow appendFooterRow() {
        if (this.getFooterRows().size() == 0) {
            return this.columnLayers.get(0).asFooterRow();
        }
        return this.insertColumnLayer(this.getLastFooterLayerIndex() + 1).asFooterRow();
    }

    protected List<ColumnLayer> getColumnLayers() {
        return Collections.unmodifiableList(this.columnLayers);
    }

    public List<HeaderRow> getHeaderRows() {
        List<HeaderRow> rows = this.columnLayers.stream().filter(ColumnLayer::isHeaderRow).map(ColumnLayer::asHeaderRow).collect(Collectors.toList());
        Collections.reverse(rows);
        return rows;
    }

    public List<FooterRow> getFooterRows() {
        return this.columnLayers.stream().filter(ColumnLayer::isFooterRow).map(ColumnLayer::asFooterRow).collect(Collectors.toList());
    }

    private ColumnLayer insertColumnLayer(int index) {
        ColumnLayer innerLayer = this.columnLayers.get(index - 1);
        List<AbstractColumn<?>> groups = ColumnGroupHelpers.wrapInSeparateColumnGroups(innerLayer.getColumns(), this);
        ColumnLayer layer = new ColumnLayer(this, groups);
        this.columnLayers.add(index, layer);
        return layer;
    }

    protected ColumnLayer insertColumnLayer(int index, List<AbstractColumn<?>> columns) {
        ColumnLayer layer = new ColumnLayer(this, columns);
        this.columnLayers.add(index, layer);
        return layer;
    }

    protected void removeColumnLayer(ColumnLayer layer) {
        if (layer.equals(this.columnLayers.get(0))) {
            throw new IllegalArgumentException("The bottom column layer cannot be removed");
        }
        layer.getColumns().forEach(column -> {
            Element parent = column.getElement().getParent();
            int insertIndex = parent.indexOfChild(column.getElement());
            parent.insertChild(insertIndex, (Element[])((ColumnGroup)column).getChildColumns().stream().map(HasElement::getElement).toArray(Element[]::new));
            column.getElement().removeFromParent();
        });
        this.columnLayers.remove(layer);
    }

    private ColumnLayer insertInmostColumnLayer(boolean forHeaderRow, boolean forFooterRow) {
        ColumnLayer bottomLayer = this.columnLayers.get(0);
        List<AbstractColumn<?>> columns = bottomLayer.getColumns();
        List<AbstractColumn<?>> groups = ColumnGroupHelpers.wrapInSeparateColumnGroups(columns, this);
        ColumnLayer newBottomLayer = new ColumnLayer(this, columns);
        IntStream.range(0, groups.size()).forEach(i -> {
            if (forFooterRow) {
                ((AbstractColumn)groups.get(i)).setFooterRenderer(((AbstractColumn)columns.get(i)).getFooterRenderer());
                ((AbstractColumn)columns.get(i)).setFooterRenderer(null);
            }
            if (forHeaderRow) {
                ((AbstractColumn)groups.get(i)).setHeaderRenderer(((AbstractColumn)columns.get(i)).getHeaderRenderer());
                ((AbstractColumn)columns.get(i)).setHeaderRenderer(null);
            }
        });
        if (forFooterRow && bottomLayer.isHeaderRow()) {
            newBottomLayer.setHeaderRow(bottomLayer.asHeaderRow());
            bottomLayer.setHeaderRow(null);
        }
        if (forHeaderRow && bottomLayer.isFooterRow()) {
            newBottomLayer.setFooterRow(bottomLayer.asFooterRow());
            bottomLayer.setFooterRow(null);
        }
        bottomLayer.setColumns(groups);
        this.columnLayers.add(0, newBottomLayer);
        if (bottomLayer.isHeaderRow() && bottomLayer.asHeaderRow().equals(this.defaultHeaderRow)) {
            bottomLayer.updateSortingIndicators(true);
            newBottomLayer.updateSortingIndicators(false);
        }
        return newBottomLayer;
    }

    private int getLastHeaderLayerIndex() {
        for (int i = this.columnLayers.size() - 1; i >= 0; --i) {
            if (!this.columnLayers.get(i).isHeaderRow()) continue;
            return i;
        }
        return -1;
    }

    private int getLastFooterLayerIndex() {
        for (int i = this.columnLayers.size() - 1; i >= 0; --i) {
            if (!this.columnLayers.get(i).isFooterRow()) continue;
            return i;
        }
        return -1;
    }

    public void setDataProvider(DataProvider<T, ?> dataProvider) {
        Objects.requireNonNull(dataProvider, "data provider cannot be null");
        this.deselectAll();
        this.getDataCommunicator().setDataProvider(dataProvider, null);
        if (this.getSelectionModel() instanceof GridMultiSelectionModel) {
            GridMultiSelectionModel model = (GridMultiSelectionModel)this.getSelectionModel();
            model.setSelectAllCheckboxVisibility(model.getSelectAllCheckboxVisibility());
        }
    }

    public DataProvider<T, ?> getDataProvider() {
        return this.getDataCommunicator().getDataProvider();
    }

    public DataCommunicator<T> getDataCommunicator() {
        return this.dataCommunicator;
    }

    public int getPageSize() {
        return this.getElement().getProperty("pageSize", 50);
    }

    public void setPageSize(int pageSize) {
        if (pageSize <= 0) {
            throw new IllegalArgumentException("The pageSize should be greater than zero. Was " + pageSize);
        }
        this.getElement().setProperty("pageSize", (double)pageSize);
        this.getElement().callFunction("$connector.reset", new Serializable[0]);
        this.setRequestedRange(0, pageSize);
        this.getDataCommunicator().reset();
    }

    public GridSelectionModel<T> getSelectionModel() {
        assert (this.selectionModel != null) : "No selection model set by " + ((Object)((Object)this)).getClass().getName() + " constructor";
        return this.selectionModel;
    }

    protected void setSelectionModel(GridSelectionModel<T> model, SelectionMode selectionMode) {
        Objects.requireNonNull(model, "selection model cannot be null");
        Objects.requireNonNull(selectionMode, "selection mode cannot be null");
        if (this.selectionModel != null && this.selectionModel instanceof AbstractGridExtension) {
            ((AbstractGridExtension)((Object)this.selectionModel)).remove();
        }
        this.selectionModel = model;
        this.selectionMode = selectionMode;
        this.updateSelectionModeOnClient();
    }

    private void updateSelectionModeOnClient() {
        this.getElement().callFunction("$connector.setSelectionMode", new Serializable[]{this.selectionMode.name()});
    }

    public GridSelectionModel<T> setSelectionMode(SelectionMode selectionMode) {
        Objects.requireNonNull(selectionMode, "Selection mode cannot be null.");
        GridSelectionModel model = selectionMode.createModel(this);
        this.setSelectionModel(model, selectionMode);
        return model;
    }

    public SingleSelect<Grid<T>, T> asSingleSelect() {
        GridSelectionModel<T> model = this.getSelectionModel();
        if (!(model instanceof GridSingleSelectionModel)) {
            throw new IllegalStateException("Grid is not in single select mode, it needs to be explicitly set to such with setSelectionMode(SelectionMode.SINGLE) before being able to use single selection features.");
        }
        return ((GridSingleSelectionModel)model).asSingleSelect();
    }

    public MultiSelect<Grid<T>, T> asMultiSelect() {
        GridSelectionModel<T> model = this.getSelectionModel();
        if (!(model instanceof GridMultiSelectionModel)) {
            throw new IllegalStateException("Grid is not in multi select mode, it needs to be explicitly set to such with setSelectionMode(SelectionMode.MULTI) before being able to use multi selection features.");
        }
        return ((GridMultiSelectionModel)model).asMultiSelect();
    }

    public Set<T> getSelectedItems() {
        return this.getSelectionModel().getSelectedItems();
    }

    public void select(T item) {
        this.getSelectionModel().select(item);
    }

    public void deselect(T item) {
        this.getSelectionModel().deselect(item);
    }

    public void deselectAll() {
        this.getSelectionModel().deselectAll();
    }

    void doClientSideSelection(Set<T> items) {
        this.callSelectionFunctionForItems("doSelection", items);
    }

    void doClientSideDeselection(Set<T> items) {
        this.callSelectionFunctionForItems("doDeselection", items);
    }

    private void callSelectionFunctionForItems(String function, Set<T> items) {
        if (items.isEmpty()) {
            return;
        }
        Serializable[] values = new Serializable[items.size() + 1];
        List<Serializable> collect = items.stream().map(item -> this.generateJsonForSelection(item)).map(item -> item).collect(Collectors.toList());
        collect.add(1, Boolean.valueOf(false));
        collect.toArray(values);
        this.getElement().callFunction("$connector." + function, values);
    }

    private JsonObject generateJsonForSelection(T item) {
        JsonObject json = Json.createObject();
        json.put("key", this.getDataCommunicator().getKeyMapper().key(item));
        return json;
    }

    public Registration addSelectionListener(SelectionListener<Grid<T>, T> listener) {
        return this.getSelectionModel().addSelectionListener(listener);
    }

    public void setItemDetailsRenderer(Renderer<T> renderer) {
        Rendering rendering;
        this.detailsManager.destroyAllData();
        this.itemDetailsDataGenerator = null;
        if (renderer == null) {
            return;
        }
        if (this.detailsTemplate == null) {
            rendering = renderer.render(this.getElement(), this.getDataCommunicator().getKeyMapper());
            this.detailsTemplate = rendering.getTemplateElement();
            this.detailsTemplate.setAttribute("class", "row-details");
        } else {
            rendering = renderer.render(this.getElement(), this.getDataCommunicator().getKeyMapper(), this.detailsTemplate);
        }
        Optional dataGenerator = rendering.getDataGenerator();
        if (dataGenerator.isPresent()) {
            this.itemDetailsDataGenerator = (DataGenerator)dataGenerator.get();
        }
    }

    @Synchronize(value={"column-reordering-allowed-changed"})
    public boolean isColumnReorderingAllowed() {
        return this.getElement().getProperty("columnReorderingAllowed", false);
    }

    public void setColumnReorderingAllowed(boolean columnReorderingAllowed) {
        if (this.isColumnReorderingAllowed() != columnReorderingAllowed) {
            this.getElement().setProperty("columnReorderingAllowed", columnReorderingAllowed);
        }
    }

    private List<ColumnBase<?>> getTopLevelColumns() {
        return this.getElement().getChildren().map(element -> element.getComponent()).filter(component -> component.isPresent() && component.get() instanceof ColumnBase).map(component -> (ColumnBase)component.get()).collect(Collectors.toList());
    }

    public List<Column<T>> getColumns() {
        ArrayList ret = new ArrayList();
        this.getTopLevelColumns().forEach(column -> this.appendChildColumns(ret, (ColumnBase<?>)column));
        return Collections.unmodifiableList(ret);
    }

    public Column<T> getColumnByKey(String columnKey) {
        return this.keyToColumnMap.get(columnKey);
    }

    public void removeColumnByKey(String columnKey) {
        Objects.requireNonNull(columnKey, "columnKey should not be null");
        Column<T> columnByKey = this.getColumnByKey(columnKey);
        if (columnByKey == null) {
            throw new IllegalArgumentException("The column with key '" + columnKey + "' is not part of this Grid");
        }
        this.removeColumn(columnByKey);
    }

    public void removeColumn(Column<T> column) {
        Objects.requireNonNull(column, "column should not be null");
        if (!((Object)((Object)column.getGrid())).equals((Object)this) || column.getElement().getParent() == null) {
            throw new IllegalArgumentException("The column with key '" + column.getKey() + "' is not part of this Grid");
        }
        this.removeColumnAndColumnGroupsIfNeeded(column);
        column.destroyDataGenerators();
        this.keyToColumnMap.remove(column.getKey());
        this.idToColumnMap.remove(column.getInternalId());
    }

    private void removeColumnAndColumnGroupsIfNeeded(Column<?> column) {
        Component parent = (Component)column.getParent().get();
        parent.getElement().removeChild(new Element[]{column.getElement()});
        this.columnLayers.get(0).removeColumn(column);
        if (!parent.equals((Object)this)) {
            this.removeEmptyColumnGroups((ColumnGroup)parent, 1);
        }
    }

    private void removeEmptyColumnGroups(ColumnGroup columnGroup, int columnLayerIndex) {
        Component parent = (Component)columnGroup.getParent().get();
        if (columnGroup.getChildColumns().size() == 0) {
            parent.getElement().removeChild(new Element[]{columnGroup.getElement()});
            this.columnLayers.get(columnLayerIndex).removeColumn(columnGroup);
            if (!parent.equals((Object)this)) {
                this.removeEmptyColumnGroups((ColumnGroup)parent, columnLayerIndex + 1);
            }
        }
    }

    public void setDetailsVisible(T item, boolean visible) {
        this.detailsManager.setDetailsVisible(item, visible);
    }

    public void setDetailsVisibleOnClick(boolean detailsVisibleOnClick) {
        if (this.detailsVisibleOnClick != detailsVisibleOnClick) {
            this.detailsVisibleOnClick = detailsVisibleOnClick;
            this.getElement().callFunction("$connector.setDetailsVisibleOnClick", new Serializable[]{Boolean.valueOf(detailsVisibleOnClick)});
        }
    }

    public boolean isDetailsVisibleOnClick() {
        return this.detailsVisibleOnClick;
    }

    public boolean isDetailsVisible(T item) {
        return this.detailsManager.isDetailsVisible(item);
    }

    public Registration addSortListener(ComponentEventListener<SortEvent<Grid<T>, GridSortOrder<T>>> listener) {
        return this.addListener(SortEvent.class, listener);
    }

    public void setMultiSort(boolean multiSort) {
        this.getElement().setAttribute("multi-sort", multiSort);
    }

    public boolean isMultiSort() {
        String multiSort = this.getElement().getAttribute("multi-sort");
        return multiSort == null ? false : Boolean.valueOf(multiSort);
    }

    private List<Column<T>> fetchChildColumns(ColumnGroup columnGroup) {
        ArrayList<Column<T>> ret = new ArrayList<Column<T>>();
        columnGroup.getChildColumns().forEach(column -> this.appendChildColumns((List<Column<T>>)ret, (ColumnBase<?>)column));
        return ret;
    }

    private void appendChildColumns(List<Column<T>> list, ColumnBase<?> column) {
        if (column instanceof Column) {
            list.add((Column)column);
        } else if (column instanceof ColumnGroup) {
            list.addAll(this.fetchChildColumns((ColumnGroup)column));
        }
    }

    @ClientCallable
    private void select(int key) {
        this.getSelectionModel().selectFromClient(this.findByKey(key));
    }

    @ClientCallable
    private void deselect(int key) {
        this.getSelectionModel().deselectFromClient(this.findByKey(key));
    }

    private T findByKey(int key) {
        Object item = this.getDataCommunicator().getKeyMapper().get(String.valueOf(key));
        if (item == null) {
            throw new IllegalStateException("Unkonwn key: " + key);
        }
        return (T)item;
    }

    @ClientCallable(value=DisabledUpdateMode.ALWAYS)
    private void confirmUpdate(int id) {
        this.getDataCommunicator().confirmUpdate(id);
    }

    @ClientCallable(value=DisabledUpdateMode.ALWAYS)
    private void setRequestedRange(int start, int length) {
        this.getDataCommunicator().setRequestedRange(start, length);
    }

    @ClientCallable
    private void setDetailsVisible(String key) {
        if (key == null) {
            this.detailsManager.setDetailsVisibleFromClient(Collections.emptySet());
        } else {
            this.detailsManager.setDetailsVisibleFromClient(Collections.singleton(this.getDataCommunicator().getKeyMapper().get(key)));
        }
    }

    @ClientCallable
    private void sortersChanged(JsonArray sorters) {
        GridSortOrderBuilder sortOrderBuilder = new GridSortOrderBuilder();
        block8: for (int i = 0; i < sorters.length(); ++i) {
            JsonObject sorter = sorters.getObject(i);
            Column<T> column = this.idToColumnMap.get(sorter.getString("path"));
            if (column == null) {
                throw new IllegalArgumentException("Received a sorters changed call from the client for a non-existent column");
            }
            switch (sorter.getString("direction")) {
                case "asc": {
                    sortOrderBuilder.thenAsc(column);
                    continue block8;
                }
                case "desc": {
                    sortOrderBuilder.thenDesc(column);
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("Received a sorters changed call from the client containing an invalid sorting direction");
                }
            }
        }
        this.setSortOrder(sortOrderBuilder.build(), true);
    }

    CompositeDataGenerator<T> getDataGenerator() {
        return this.gridDataGenerator;
    }

    private void setSortOrder(List<GridSortOrder<T>> order, boolean userOriginated) {
        Objects.requireNonNull(order, "Sort order list cannot be null");
        if (this.sortOrder.equals(order)) {
            return;
        }
        this.sortOrder.clear();
        if (order.isEmpty()) {
            this.getDataCommunicator().setBackEndSorting(Collections.emptyList());
            this.getDataCommunicator().setInMemorySorting(null);
            this.fireEvent((ComponentEvent)new SortEvent((Component)this, new ArrayList<GridSortOrder<T>>(this.sortOrder), userOriginated));
            return;
        }
        this.sortOrder.addAll(order);
        this.sort(userOriginated);
    }

    private void sort(boolean userOriginated) {
        this.getDataCommunicator().setInMemorySorting(this.createSortingComparator());
        ArrayList sortProperties = new ArrayList();
        this.sortOrder.stream().map(order -> ((Column)order.getSorted()).getSortOrder(order.getDirection())).forEach(s -> s.forEach(sortProperties::add));
        this.getDataCommunicator().setBackEndSorting(sortProperties);
        this.fireEvent((ComponentEvent)new SortEvent((Component)this, new ArrayList<GridSortOrder<T>>(this.sortOrder), userOriginated));
    }

    protected SerializableComparator<T> createSortingComparator() {
        BinaryOperator operator = (comparator1, comparator2) -> comparator1.thenComparing((Comparator)comparator2)::compare;
        return this.sortOrder.stream().map(order -> ((Column)order.getSorted()).getComparator(order.getDirection())).reduce(operator).orElse(null);
    }

    public void setHeightByRows(boolean heightByRows) {
        this.getElement().setProperty("heightByRows", heightByRows);
    }

    @Synchronize(value={"height-by-rows-changed"})
    public boolean isHeightByRows() {
        return this.getElement().getProperty("heightByRows", false);
    }

    public void onEnabledStateChanged(boolean enabled) {
        super.onEnabledStateChanged(enabled);
        this.getDataCommunicator().reset();
    }

    private static int compareMaybeComparables(Object a, Object b) {
        if (Grid.hasCommonComparableBaseType(a, b)) {
            return Grid.compareComparables(a, b);
        }
        return Grid.compareComparables(Objects.toString(a, ""), Objects.toString(b, ""));
    }

    private static boolean hasCommonComparableBaseType(Object a, Object b) {
        if (a instanceof Comparable && b instanceof Comparable) {
            Class<?> bClass;
            Class<?> aClass = a.getClass();
            if (aClass == (bClass = b.getClass())) {
                return true;
            }
            Class baseType = ReflectTools.findCommonBaseType(aClass, bClass);
            if (Comparable.class.isAssignableFrom(baseType)) {
                return true;
            }
        }
        return a == null && b instanceof Comparable || b == null && a instanceof Comparable;
    }

    private static int compareComparables(Object a, Object b) {
        return Comparator.nullsLast(Comparator.naturalOrder()).compare(a, b);
    }

    private class DetailsManager
    extends AbstractGridExtension<T> {
        private final Set<T> detailsVisible;

        public DetailsManager(Grid<T> grid2) {
            super(grid2);
            this.detailsVisible = new HashSet();
        }

        public void setDetailsVisible(T item, boolean visible) {
            boolean refresh = false;
            if (!visible) {
                refresh = this.detailsVisible.remove(item);
            } else {
                this.detailsVisible.add(item);
                refresh = true;
            }
            if (Grid.this.itemDetailsDataGenerator != null && refresh) {
                this.refresh(item);
            }
        }

        public boolean isDetailsVisible(T item) {
            return Grid.this.itemDetailsDataGenerator != null && this.detailsVisible.contains(item);
        }

        public void generateData(T item, JsonObject jsonObject) {
            if (Grid.this.itemDetailsDataGenerator != null && this.isDetailsVisible(item)) {
                jsonObject.put("detailsOpened", true);
                Grid.this.itemDetailsDataGenerator.generateData(item, jsonObject);
            }
        }

        public void destroyData(T item) {
            this.detailsVisible.remove(item);
            if (Grid.this.itemDetailsDataGenerator != null) {
                Grid.this.itemDetailsDataGenerator.destroyData(item);
            }
        }

        public void destroyAllData() {
            this.detailsVisible.clear();
            if (Grid.this.itemDetailsDataGenerator != null) {
                Grid.this.itemDetailsDataGenerator.destroyAllData();
            }
        }

        public void refreshData(T item) {
            if (Grid.this.itemDetailsDataGenerator != null && this.isDetailsVisible(item)) {
                Grid.this.itemDetailsDataGenerator.refreshData(item);
            }
        }

        private void setDetailsVisibleFromClient(Set<T> items) {
            HashSet toRefresh = new HashSet();
            toRefresh.addAll(this.detailsVisible);
            toRefresh.addAll(items);
            this.detailsVisible.clear();
            this.detailsVisible.addAll(items);
            if (Grid.this.itemDetailsDataGenerator != null) {
                for (Object item : toRefresh) {
                    this.refresh(item);
                }
            }
        }
    }

    public static abstract class AbstractGridExtension<T>
    implements DataGenerator<T> {
        private Grid<T> grid;

        public AbstractGridExtension(Grid<T> grid) {
            this.extend(grid);
        }

        protected void refresh(T item) {
            this.getGrid().getDataCommunicator().refresh(item);
        }

        protected void extend(Grid<T> grid) {
            this.grid = grid;
            this.getGrid().getDataGenerator().addDataGenerator((DataGenerator)this);
        }

        protected void remove() {
            this.getGrid().getDataGenerator().removeDataGenerator((DataGenerator)this);
        }

        protected Grid<T> getGrid() {
            return this.grid;
        }
    }

    @Tag(value="vaadin-grid-column")
    public static class Column<T>
    extends AbstractColumn<Column<T>> {
        private final String columnInternalId;
        private String columnKey;
        private boolean sortingEnabled;
        private SortOrderProvider sortOrderProvider = (SortOrderProvider & Serializable)direction -> {
            String key = this.getKey();
            if (key == null) {
                return Stream.empty();
            }
            return Stream.of(new QuerySortOrder(key, direction));
        };
        private SerializableComparator<T> comparator;
        private Registration columnDataGeneratorRegistration;

        public Column(Grid<T> grid, String columnId, Renderer<T> renderer) {
            super(grid);
            this.columnInternalId = columnId;
            this.comparator = (SerializableComparator & Serializable)(a, b) -> 0;
            CompositeDataGenerator<T> gridDataGenerator = grid.getDataGenerator();
            Rendering rendering = renderer.render(this.getElement(), (DataKeyMapper)((KeyMapper)this.getGrid().getDataCommunicator().getKeyMapper()));
            Optional dataGenerator = rendering.getDataGenerator();
            if (dataGenerator.isPresent()) {
                this.columnDataGeneratorRegistration = gridDataGenerator.addDataGenerator((DataGenerator)dataGenerator.get());
            }
        }

        protected void destroyDataGenerators() {
            if (this.columnDataGeneratorRegistration != null) {
                this.columnDataGeneratorRegistration.remove();
                this.columnDataGeneratorRegistration = null;
            }
        }

        protected String getInternalId() {
            return this.columnInternalId;
        }

        public Column<T> setWidth(String width) {
            this.getElement().setProperty("width", width);
            return this;
        }

        @Synchronize(value={"width-changed"})
        public String getWidth() {
            return this.getElement().getProperty("width");
        }

        public Column<T> setFlexGrow(int flexGrow) {
            this.getElement().setProperty("flexGrow", (double)flexGrow);
            return this;
        }

        @Synchronize(value={"flex-grow-changed"})
        public int getFlexGrow() {
            return this.getElement().getProperty("flexGrow", 1);
        }

        public Column<T> setKey(String key) {
            Objects.requireNonNull(key, "Column key cannot be null");
            if (this.columnKey != null) {
                throw new IllegalStateException("Column key cannot be changed");
            }
            this.getGrid().setColumnKey(key, this);
            this.columnKey = key;
            return this;
        }

        public String getKey() {
            return this.columnKey;
        }

        @Override
        public Element getElement() {
            return super.getElement();
        }

        public Column<T> setComparator(Comparator<T> comparator) {
            Objects.requireNonNull(comparator, "Comparator must not be null");
            this.setSortable(true);
            this.comparator = comparator::compare;
            return this;
        }

        public <V extends Comparable<? super V>> Column<T> setComparator(ValueProvider<T, V> keyExtractor) {
            Objects.requireNonNull(keyExtractor, "Key extractor must not be null");
            this.setComparator(Comparator.comparing(keyExtractor, Comparator.nullsLast(Comparator.naturalOrder())));
            return this;
        }

        public SerializableComparator<T> getComparator(SortDirection sortDirection) {
            boolean reverse;
            Objects.requireNonNull(this.comparator, "No comparator defined for sorted column.");
            this.setSortable(true);
            boolean bl = reverse = sortDirection != SortDirection.ASCENDING;
            return reverse ? this.comparator.reversed()::compare : this.comparator;
        }

        public Column<T> setSortProperty(String ... properties) {
            Objects.requireNonNull(properties, "Sort properties must not be null");
            this.setSortable(true);
            this.sortOrderProvider = (SortOrderProvider & Serializable)dir -> Arrays.stream(properties).map(s -> new QuerySortOrder(s, dir));
            return this;
        }

        public Column<T> setSortOrderProvider(SortOrderProvider provider) {
            Objects.requireNonNull(provider, "Sort order provider must not be null");
            this.setSortable(true);
            this.sortOrderProvider = provider;
            return this;
        }

        public Stream<QuerySortOrder> getSortOrder(SortDirection direction) {
            return this.sortOrderProvider.apply(direction);
        }

        public Column<T> setSortable(boolean sortable) {
            if (this.sortingEnabled == sortable) {
                return this;
            }
            this.sortingEnabled = sortable;
            HeaderRow defaultHeaderRow = this.getGrid().getDefaultHeaderRow();
            if (defaultHeaderRow != null) {
                ((HeaderRow.HeaderCell)defaultHeaderRow.getCell(this)).getColumn().setSortingIndicators(sortable);
            }
            return this;
        }

        public boolean isSortable() {
            return this.sortingEnabled;
        }

        public Column<T> setHeader(String labelText) {
            HeaderRow defaultHeaderRow = this.getGrid().getDefaultHeaderRow();
            if (defaultHeaderRow == null) {
                defaultHeaderRow = this.getGrid().addFirstHeaderRow();
            }
            ((HeaderRow.HeaderCell)defaultHeaderRow.getCell(this)).setText(labelText);
            return this;
        }

        public Column<T> setFooter(String labelText) {
            ((FooterRow.FooterCell)this.getGrid().getColumnLayers().get(0).asFooterRow().getCell(this)).setText(labelText);
            return this;
        }

        public Column<T> setHeader(Component headerComponent) {
            HeaderRow defaultHeaderRow = this.getGrid().getDefaultHeaderRow();
            if (defaultHeaderRow == null) {
                defaultHeaderRow = this.getGrid().addFirstHeaderRow();
            }
            ((HeaderRow.HeaderCell)defaultHeaderRow.getCell(this)).setComponent(headerComponent);
            return this;
        }

        public Column<T> setFooter(Component footerComponent) {
            ((FooterRow.FooterCell)this.getGrid().getColumnLayers().get(0).asFooterRow().getCell(this)).setComponent(footerComponent);
            return this;
        }

        @Override
        protected Column<?> getBottomLevelColumn() {
            return this;
        }
    }

    public static enum SelectionMode {
        SINGLE{

            @Override
            protected <T> GridSelectionModel<T> createModel(final Grid<T> grid) {
                return new AbstractGridSingleSelectionModel<T>(grid){

                    @Override
                    protected void fireSelectionEvent(SelectionEvent<Grid<T>, T> event) {
                        grid.fireEvent((ComponentEvent)event);
                    }
                };
            }
        }
        ,
        MULTI{

            @Override
            protected <T> GridSelectionModel<T> createModel(final Grid<T> grid) {
                return new AbstractGridMultiSelectionModel<T>(grid){

                    @Override
                    protected void fireSelectionEvent(SelectionEvent<Grid<T>, T> event) {
                        grid.fireEvent((ComponentEvent)event);
                    }
                };
            }
        }
        ,
        NONE{

            @Override
            protected <T> GridSelectionModel<T> createModel(Grid<T> grid) {
                return new GridNoneSelectionModel();
            }
        };


        protected abstract <T> GridSelectionModel<T> createModel(Grid<T> var1);
    }

    private final class UpdateQueue
    implements ArrayUpdater.Update {
        private List<Runnable> queue = new ArrayList<Runnable>();

        private UpdateQueue(int size) {
            this.enqueue("$connector.updateSize", Integer.valueOf(size));
            Grid.this.getElement().setProperty("size", (double)size);
        }

        public void set(int start, List<JsonValue> items) {
            this.enqueue("$connector.set", Integer.valueOf(start), (Serializable)items.stream().collect(JsonUtils.asArray()));
        }

        public void clear(int start, int length) {
            this.enqueue("$connector.clear", Integer.valueOf(start), Integer.valueOf(length));
        }

        public void commit(int updateId) {
            this.enqueue("$connector.confirm", Integer.valueOf(updateId));
            this.queue.forEach(Runnable::run);
            this.queue.clear();
        }

        private void enqueue(String name, Serializable ... arguments) {
            this.queue.add(() -> Grid.this.getElement().callFunction(name, arguments));
        }
    }
}

